/** 
 \example test-parse.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#include "rtx/message.h"
#include "rtx/error.h"
#include "rtx/parse.h"
#include "rtx/hash.h"

char * PID = "struct {float e; float kp; float prop; float prop_high; float ki; float integ; float integ_high; float kd; float diff; float diff_high; int ds; int count; float e_prev; float e_diff; float u; float u_high; int speed_comp;} PID;";
char * PITCH = "struct {float act; float sp; PID p; float max; int test;} PITCH;";
char * pitch = "PITCH pitch;";

char * TEST_T = "struct {int a; int b;} TEST_T;";
char * PLS_T = "struct {int numVals; int range[10];} PLS_T;";
char * TEST1_T = "struct {PLS_T pls[3]; double x; TEST_T y[10];} TEST1_T;";
char * cmplx = "TEST1_T cmplx;";
char * RIEGL_SCAN_T = "struct {int numPoints; float range[667]; float angle[667]; char amplitude[667];} RIEGL_SCAN;";

char buf[4096];
char typeStr[1024];
RtxParseSymTabs * symTabs;

typedef struct {float e; float kp; float prop; float prop_high; float ki; float integ; float integ_high; float kd; float diff; float diff_high; int ds; int count; float e_prev; float e_diff; float u; float u_high; int speed_comp;} PID_T;
typedef struct {float act; float sp; PID_T p; float max; int test;} PITCH_T;

PITCH_T p = {1.0, 2.0, {3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13, 14, 15.0, 16.0, 17.0, 18.0, 19}, 20.0, 21};

int
main (void)
{
    RtxParseToken curToken;
    int typeStrIndex = 0;
    RtxParseVar  v1, v2, v3, v4, v5, v6, v7, v8, v9;

    rtx_error_init ("test-parse", RTX_ERROR_STDERR, NULL);

    assert(symTabs = rtx_parse_init());

    printf ("doing TEST_T\n");
    memset (&v1, 0, sizeof (v1));
    memset (&curToken, 0, sizeof (curToken));
    if (rtx_parse_decl (TEST_T, &typeStrIndex, &curToken, &v1, symTabs) != -1)
        rtx_parse_print_decl (&v1, 0);
    assert(rtx_parse_add_type_symbol (&v1, 0, symTabs->typeTable, &symTabs->typeNumber) != -1);

    printf ("doing PLS_T\n");
    memset (&v2, 0, sizeof (v2));
    memset (&curToken, 0, sizeof (curToken));
    typeStrIndex = 0;
    if (rtx_parse_decl (PLS_T, &typeStrIndex, &curToken, &v2, symTabs) != -1)
        rtx_parse_print_decl (&v2, 0);
    assert(rtx_parse_add_type_symbol (&v2, 0, symTabs->typeTable, &symTabs->typeNumber) != -1);

    printf ("doing TEST1_T\n");
    memset (&v3, 0, sizeof (v3));
    memset (&curToken, 0, sizeof (curToken));
    typeStrIndex = 0;
    if (rtx_parse_decl (TEST1_T, &typeStrIndex, &curToken, &v3, symTabs) != -1)
        rtx_parse_print_decl (&v3, 0);
    assert(rtx_parse_add_type_symbol (&v3, 0, symTabs->typeTable, &symTabs->typeNumber) != -1);
    printf ("doing PID\n");
    typeStrIndex = 0;
    memset (&v6, 0, sizeof (v6));
    memset (&curToken, 0, sizeof (curToken));
    assert(rtx_parse_decl (PID, &typeStrIndex, &curToken, &v6, symTabs));
    rtx_parse_print_decl (&v6, 0);
    assert(rtx_parse_add_type_symbol (&v6, 0, symTabs->typeTable, &symTabs->typeNumber) != -1);

    printf ("doing PITCH\n");
    typeStrIndex = 0;
    memset (&v7, 0, sizeof (v7));
    memset (&curToken, 0, sizeof (curToken));
    assert(rtx_parse_decl (PITCH, &typeStrIndex, &curToken, &v7, symTabs) != -1);
    rtx_parse_print_decl (&v7, 0);
    assert(rtx_parse_add_type_symbol (&v7, 0, symTabs->typeTable, &symTabs->typeNumber) != -1);

    printf ("doing pitch\n");
    typeStrIndex = 0;
    memset (&v8, 0, sizeof (v8));
    memset (&curToken, 0, sizeof (curToken));
    assert(rtx_parse_decl (pitch, &typeStrIndex, &curToken, &v8, symTabs) != -1);
    rtx_parse_print_decl (&v8, 0);
    assert(rtx_parse_expand_var_definition(&v8, symTabs->typeTable) != -1);

    rtx_parse_print_decl (&v8, 0);
    printf ("generated declaration\n");
    rtx_parse_generate_var_decl (&v8, buf);
    printf ("%s\n", buf);
    typeStrIndex = 0;
    memset (&v9, 0, sizeof (v9));
    memset (&curToken, 0, sizeof (curToken));
    assert(rtx_parse_decl (buf, &typeStrIndex, &curToken, &v9, symTabs) != -1);
    rtx_parse_print_decl (&v9, 0);
    printf ("\n-----------------------------------------------\n");
    buf[0] = '\0';
    rtx_parse_print_var (&v9, &p, buf);
    printf ("%s\n", buf);
    printf ("\n--------\n");
    memset (&v4, 0, sizeof (v4));
    memset (&curToken, 0, sizeof (curToken));
    typeStrIndex = 0;
    if (rtx_parse_decl (cmplx, &typeStrIndex, &curToken, &v4, symTabs) != -1)
        rtx_parse_print_decl (&v4, 0);
    printf ("\n--------\n");
    assert(rtx_parse_expand_var_definition(&v4, symTabs->typeTable) != -1);

    rtx_parse_print_decl (&v4, 0);
    printf ("generated declaration\n");
    buf[0] = '\0';
    rtx_parse_generate_var_decl (&v4, buf);
    printf ("%s\n", buf);
    printf ("\n-----------------------------------------------\n");
    memset (&v5, 0, sizeof (v5));
    memset (&curToken, 0, sizeof (curToken));
    typeStrIndex = 0;
    if (rtx_parse_decl (RIEGL_SCAN_T, &typeStrIndex, &curToken, &v5, symTabs) != -1)
        rtx_parse_print_decl (&v5, 0);

    /*
    if (gets (typeStr) == NULL)
        exit (0);

    while (get_next_token (s, &p, &t) > 0) {
        printf ("%s : %d", t.tokStr, t.tokId);
	if (t.tokId == TOK_INT_NUMBER)
  	    printf (" : %d", t.tokVal.intVal);
	if (t.tokId == TOK_REAL_NUMBER)
  	    printf (" : %f", t.tokVal.realVal);
	printf ("\n");
    }
    printf ("alignment of char = %d\n", primitiveDataAlign[char_t]);
    printf ("alignment of short = %d\n", primitiveDataAlign[short_t]);
    printf ("alignment of int = %d\n", primitiveDataAlign[int_t]);
    printf ("alignment of long = %d\n", primitiveDataAlign[long_t]);
    printf ("alignment of float = %d\n", primitiveDataAlign[float_t]);
    printf ("alignment of double = %d\n", primitiveDataAlign[double_t]);

    var.next = NULL;
    var.size = 0;
    var.offset = 0;
    var.alignment = 0;
    if (rtx_parse_decl (typeStr, &typeStrIndex, &curToken, &var, &symTabs)) != -1)
        rtx_parse_print_decl (&var, 0);
    */
    return (0);
}

