/**
 \example test-param.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include        <unistd.h>
#include	<stdio.h>
#include        <stdlib.h>

#include	"../include/rtx/param.h"

int
main(int ac, char *av[])
{
	double	x, y[3], zBlah;
	int	a, b[2];
	char	s[100];
	RtxParamStream	*pf;

	if (ac > 1)
	    pf = rtx_param_open_preprocessed("test-param.conf", 1, NULL, ac-1, &av[1]);
	else
	    pf = rtx_param_open("test-param.conf", 1, NULL);
	if (pf == NULL) {
	    fprintf (stderr, "rtx_param_open failed\n");
	    exit (1);
	}
	rtx_param_get_double(pf, "x", &x, 1);
	rtx_param_get_double(pf, "y", y, 3);
	rtx_param_get_double(pf, "zBlah", &zBlah, 1);
	rtx_param_get_int(pf, "a", &a, 1);
	rtx_param_get_int(pf, "b", b, 2);
	rtx_param_get_string(pf, "s", s, 100);

	printf("x %f, y %f %f %f zBlah %f\n", x, y[0], y[1], y[2], zBlah);
	printf("a %d b %d %d s %s\n", a, b[0], b[1], s);
	return (0);
}
