/**
 \example test-simple-httpd.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "../include/rtx/httpd.h"
#include "../include/rtx/error.h"
#include "../include/rtx/message.h"


#ifdef i486_lynxos310
extern char *optarg;
extern int opterr;
#endif

RtxHttpd server;

static void sigpipeh()
{

}

int 
hello_handler(RtxHttpdReq * r)
{
    char * name;
    char hello[100];

    if (!(r->method == RTX_HTTPD_M_GET && strcmp(r->url,"/hello")==0 )){
        return 0;
    }

    if ((name = rtx_hash_find(r->args, "name"))){
	snprintf(hello,sizeof(hello), "Hello %s!",name);
    } else{
	strcpy(hello,"Hello World\n");
    }
    if(rtx_httpd_resp_status(r,200,NULL)!=0){
        return rtx_error("Could not set HTTP response status");
    }
    if(rtx_httpd_resp_add_hdr(r,"Content-Type: text/plain")!=0){
        return rtx_error("Could not set Content Type");
    }
    if(rtx_httpd_send_resp(r,hello,strlen(hello))!=0){
        return rtx_error("Could not send response");
    }
    printf("Request %d for %s handled\n",r->method, r->url);

    return 0;
}

int main(int argc, char **argv)
{
	RtxHttpdConfig conf;
    
	conf.port=8000;
	conf.multi_thread=1;
	conf.debug=5;
	conf.hostfile=strdup("/data/aa/etc/hosts");
	conf.passwdfile=strdup("/data/aa/etc/xmlrpcpasswd");;
	conf.mimefile=NULL;
	conf.rootdir=strdup(".");
 
	fprintf(stderr, "Initialising simple HTTPD server\n");
	if (rtx_httpd_server_init(&server, &conf)) {
        	fprintf(stderr, "httpd_server_init() failed\n");
        	exit(1);
    	}
	signal(SIGPIPE,sigpipeh);

	rtx_httpd_server_add_handler(&server,rtx_httpd_filehandler);
	rtx_httpd_server_add_handler(&server,hello_handler);

	fprintf(stderr, "Starting HTTPD server\n");
	if (rtx_httpd_server_loop(&server)!=0)
		fprintf(stderr, "error during server execution");
    	
	exit(0);
}
