/**
 \example test-http.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../include/rtx/http.h"
#include "../include/rtx/error.h"


int main(int argc, char * argv[])
{
	char *url;
	char hostname[1024];
	unsigned int port,n;
	int r;
	// Adapted to: http://www.webservicex.net/CurrencyConvertor.asmx/ConversionRate
	if (argc < 2) {
		printf("Invalid number of argument %d\n",argc);
		printf("Usage: %s \"http://host:port/url\"\n",argv[0]);
		return -1;
	}
	r = sscanf(argv[1],"http://%1023[^:]:%d%n",hostname,&port,&n);
	if (r != 2) {
		port = 80;
		r = sscanf(argv[1],"http://%1023[^/]%n",hostname,&n);
		if (r != 1) {
			printf("Can't parse URL\n");
			printf("Usage: %s \"http://host:port/url\"\n",argv[0]);
			return -1;
		} else {
			url = argv[1]+n;
		}
	} else {
		url = argv[1]+n;
	}

	printf("Get url '%s' at '%s' port %d\n",url,hostname,port);

	RtxLongString *out = rtx_longstring_init();
	RtxHttpClient *client = rtx_http_init(hostname,port,5.0);
	RtxHash *hash = rtx_hash_create(10);
	rtx_hash_add(hash,"FromCurrency",strdup("USD"));
	rtx_hash_add(hash,"ToCurrency",strdup("AUD"));
	if (!client) {
		rtx_error_flush("main: rtx_http_init failed");
		return -1;
	}
	if (rtx_http_get(client,url,hash,out)) {
		rtx_error_flush("main: rtx_http_get failed");
		return -1;
	}
	printf("Received: %d bytes\n",rtx_longstring_length(out));
	fwrite(rtx_longstring_content(out),rtx_longstring_length(out),1,stdout);
	printf("\n---\n");
	rtx_longstring_destroy(out);
	rtx_hash_destroy(hash,free);
	rtx_http_destroy(client);

	return 0;
}


