/**
 \example test-export.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include	<stdio.h>

#include	"../include/rtx/export.h"
#include	"../include/rtx/error.h"

#define	PROG_NUMBER	170
#define XMLRPC_PORT	8010

int
main(int ac, char *av[])
{
        double	x = 0.0, y[3] = {0.0, 0.0, 0.0};
	int	a = 0, b[2] = {0, 0};
	short   as = 0;
	char	s[100];
	int     ch;
	float	angle = 0.1;
	
	if (ac > 1)
	    rtxExportDebug = 1;

	sprintf (s, "Hello");
	rtx_error_init(av[0], 0, NULL);
 	rtx_export_init();
	RTX_EXPORT(x, RTX_EXPORT_DOUBLE);
	RTX_EXPORTVEC(y, RTX_EXPORT_DOUBLE, 3);
	RTX_EXPORT(a, RTX_EXPORT_INT);
	RTX_EXPORTVEC(b, RTX_EXPORT_INT, 2);
	RTX_EXPORT(as, RTX_EXPORT_SHORT);
	rtx_export_float("angle", &angle, 1, RTX_EXPORT_POLL, "rad");
	rtx_export_float_degrees("angle_d", &angle, 1, RTX_EXPORT_POLL);
	rtx_export_float_linear("angle_d_lin", &angle, 1, RTX_EXPORT_POLL, "deg", 57.3, 0.0);

	printf ("Starting export server\n");
	if (rtx_export_server_start(0, PROG_NUMBER, "tcp", NULL) == NULL) {
		rtx_error_flush("couldn't start export server");
		exit(1);
	}
	/*
	if (rtx_export_xmlrpc_server_start(0, XMLRPC_PORT, NULL)!=0) {
		rtx_error_flush("couldn't start xmlrpc export server");
		exit(1);
	}
	*/
	printf("RTC server running on program number %d\n", PROG_NUMBER);

	for (;;) {
		printf("x %f, y %f %f %f\n", x, y[0], y[1], y[2]);
		printf("a %d b %d %d s %s\n", a, b[0], b[1], s);
		printf("as %d\n", as);

		ch = getchar();
		if (ch == 'q')
		        return (0);
	}
	printf("You should never see this line");
	return (0);
}
