/**
 \example test-error.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <assert.h>
#include <string.h>

#include "rtx/error.h"

#define ERROR "[0] test/test-error.c:34 main(): failed because i couldn't find the key blah\n"\
              "[1] test/test-error.c:35 main(): failed because thingy failed\n"\
              "[2] test/test-error.c:36 main(): failed because of previous errors."

int main(int argc, char *argv[]) {
  rtx_error_t error;

  /* Tests on an unused error. */
  assert(error = rtx_error_alloc());
  
  assert(strcmp(rtx_error_str(error), "") == 0);

  rtx_error_free(error);
  
  /* Tests on a used error. */
  assert(error = rtx_error_alloc());
  
  RTX_ERROR_PUSH_CUSTOM(error, "failed because i couldn't find the key %s", "blah");
  RTX_ERROR_PUSH_CUSTOM(error, "failed because thingy failed");
  RTX_ERROR_PUSH_DEFAULT(error);

  assert(strcmp(rtx_error_str(error), ERROR) == 0);

  rtx_error_log(error);
  assert(strcmp(rtx_error_str(error), "") == 0);
  
  rtx_error_free(error);
  
  return 0;
}
