/**
 \example socket-send.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../include/rtx/socket.h"	

int
main(int ac, char **av)
{
    int  portNum = 8002;
    char hostname[128];
    char buffer[128];
    RtxSocket   *com;

    gethostname(hostname, 128); 
    if ((com = rtx_socket_open(portNum, hostname, 0)) == NULL)
      { printf("Rtx_socket_open() failed\n"); exit(1); }

    printf("Type a string, and it will be send to Port 8002\n");
    while( gets(buffer) != NULL) 
      rtx_socket_send (com, buffer, strlen(buffer));

    rtx_socket_close(com);
    exit(0);
    }
