/** 
 * \example socket-serv.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../include/rtx/socket.h"		

int
main(int ac, char **av)
{
    int len;
    RtxSocket   *com;
    int  portNum = 8002;
    char buffer[128];

    if(ac > 1 ) portNum = atoi(av[1]); 

    printf("Socket thread listening on port %d\n", portNum);
    if ((com = rtx_socket_open(portNum, NULL, 1)) == NULL)
     { printf("rtx_socket_open() failed\n"); exit(1); }

    while( (len = rtx_socket_recv(com, buffer, sizeof(buffer))) > 0) {

      buffer[len] = 0;
      printf("Buffer [%s] \n", buffer);
      }

    printf("rtx_socket_recv() failed\n"); 
    rtx_socket_close(com);
    exit(0);
}
