/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

/**
 * \file string.c
 * \brief string handling module
 * \author Pavan Sikka
 *
 * Common string handling functions
 *
 */

#include <strings.h>
#include <string.h>

#include "rtx/defines.h"
#include "rtx/error.h"
#include "rtx/string.h"

static char rcsid[] RTX_UNUSED = "$Id: string.c 2274 2007-12-23 05:37:32Z roy029 $";

/**
 * tokenize the input string
 * 
 * @return 0 if OK, -1 on error
 */
int
rtx_string_tokenize (
		     char * inputStr,     /**< input string to be tokenized */
		     int * argc,          /**< initial size of argv on entry,
					   **  actual number of tokens on
					   **  return */
		     char * argv[]        /**< tokens */
		     )
{
    int i = 0;
    char * tok = NULL, * lasts = NULL;

    tok = strtok_r (inputStr, " \t\n\r", &lasts);
    while ((tok != NULL) && (i < * argc)) {
        argv[i++] = tok;
	tok = strtok_r (NULL, " \t\n\r", &lasts);
    }
    * argc = i;
    return (0);
}

/**
 * convert a list of tokens to a string
 *
 * @return 0 if OK, -1 on error 
 */
int
rtx_string_build (
		  char * retStr,    /**< string to be returned */
		  int strLen,       /**< maximum size of string */
		  int argc,         /**< number of tokens */
		  char * argv[]     /**< tokens */
		  )
{
    int i = 0, j = 0;

    retStr[0] = '\0';
    while (i < strLen) {
        if ((strlen(argv[j]) + 2) > (strLen - i))
	    return (rtx_error ("rtx_string_build: buffer overflow"));
	strcat (retStr, argv[j]);
	strcat (retStr, " ");
	i += strlen (argv[j]) + 1;
	j++;
    }
    return (0);
}

