/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <rtx/error.h>

#include "../include/rtx/scircbuff.h"

static char rcsid[] RTX_UNUSED = "$Id: scircbuff.c 2271 2007-12-23 04:41:55Z roy029 $";

//#define VERBOSE

RtxCircularStringBuffer * rtx_csbuffer_init(RtxCircularStringBuffer *self, unsigned int size){
	RtxCircularStringBuffer *log;
	unsigned int i;
	if (self) {
		log = self;
		log->alloc = 0;
	} else {
		log = (RtxCircularStringBuffer*)malloc(sizeof(RtxCircularStringBuffer));
		if (!log) {
			return rtx_error_null("rtx_csbuffer_init: malloc failed");
		}
		log->alloc = 1;
	}
	log->buffer = (char**)malloc(size*sizeof(char*));
	if (!log->buffer) {
		if (log->alloc) {
			free(log);
		}
		return rtx_error_null("rtx_csbuffer_init: malloc failed");
	}
	for (i=0;i<size;i++) {
		log->buffer[i] = NULL;
	}
	log->indexW = 0;
	log->indexR = 0;
	log->size = size;
	log->empty = 1;
	return log;
}

int rtx_csbuffer_is_empty(RtxCircularStringBuffer* log){
	return log->empty;
}

int rtx_csbuffer_is_full(RtxCircularStringBuffer* log){
	if((log->indexR ==log->indexW) && (!log->empty)){
		return 1;
	}
	return 0;
}

int rtx_csbuffer_pop(RtxCircularStringBuffer* log){
	if(rtx_csbuffer_is_empty(log)){
		return rtx_error("rtx_csbuffer_pop: buffer is empty");
	}
	free(log->buffer[log->indexR]);
	log->buffer[log->indexR] = NULL;
	
	log->indexR = (log->indexR+1)%log->size;
	if(log->indexR == log->indexW){
		log->empty = 1;
	}
#ifdef VERBOSE
	printf("----------------------------------------------------------- pop\n");
#endif
	return 0;
}



char* rtx_csbuffer_front(RtxCircularStringBuffer* log){
	if(!rtx_csbuffer_is_empty(log)){
		return log->buffer[log->indexR];
	}
	return NULL;
}

int rtx_csbuffer_push(RtxCircularStringBuffer* log,const char * message){
	if(message == NULL){
		return rtx_error("message is NULL");
	}
	if(rtx_csbuffer_is_full(log)){
		rtx_csbuffer_pop(log);
	}
	if((log->buffer[log->indexW] = strdup(message)) == NULL) {
		return rtx_error("push message failed");
	}

	log->indexW = (log->indexW+1)%log->size;
	log->empty = 0;
	return 0;
}

int rtx_csbuffer_dump(RtxCircularStringBuffer* log){
	int i = log->indexR;
	
	do{
		printf("\t%d\t%d\t%s",log->indexW,log->indexR,log->buffer[i]);
		i=(i+1)%log->size;	
	}while(i != log->indexW);
	
	return 0;
}

int rtx_csbuffer_clear(RtxCircularStringBuffer* log){
	unsigned int i;
	for (i=0;i<log->size;i++) {
		if (log->buffer[i]) {
			free(log->buffer[i]);
		}
		log->buffer[i] = NULL;
	}
	log->empty = 1;
	log->indexW = log->indexR = 0;
	return 0;
}

void rtx_csbuffer_destroy(RtxCircularStringBuffer* log){
	while(!rtx_csbuffer_is_empty(log)){
		rtx_csbuffer_pop(log);
	}
	if (log->alloc) {
		free(log);
	}
}

