/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <rtx/error.h>

#include "../include/rtx/longstring.h"

static char rcsid[] RTX_UNUSED = "$Id: longstring.c 2271 2007-12-23 04:41:55Z roy029 $";


#define MAX(X,Y) (((X)<(Y))?(Y):(X))
#define MIN(X,Y) (((X)>(Y))?(Y):(X))

RtxLongString* rtx_longstring_init(){
	RtxLongString *w;
	w = (RtxLongString *)malloc(sizeof(RtxLongString));
	if((w->str = (char *)malloc(sizeof(char) * 1000)) == NULL)
		return rtx_error_null("rtx_longstring_init: malloc failed");
	w->offset = 0;
	w->size = 1000;
	w->str[0] = 0;
	
	return w;	
}

int rtx_longstring_reserve(RtxLongString * w, unsigned long size){
	/* Always add a byte to be sure to put the final zero */
	size += 1;
	free(w->str);
	if((w->str = (char *)malloc(sizeof(char) * size)) == NULL) {
		return rtx_error("rtx_longstring_reserve: malloc failed");
	}
	w->offset = 0;
	w->size = size;
	w->str[0] = 0;
	return 0;
}

int rtx_longstring_reset(RtxLongString * w){
	return rtx_longstring_reserve(w,1000);
}

int rtx_longstring_clear(RtxLongString * w){
	w->offset=0;
	w->str[0] = 0;
	return 0;
}


int rtx_longstring_concat(RtxLongString * w, const char *src){
	
	char *p = w->str;
	int len = strlen(src);

	if((w->offset+len) >= w->size){
		unsigned int newsize = MAX(w->size + 1000,w->offset+len+1);
		if((w->str = (char *)realloc((void *)w->str, sizeof(char) * newsize)) == NULL)
			return rtx_error("rtx_longstring_concat: realloc failed");
		w->size = newsize;
	}
	
	p = w->str + w->offset;

	strcpy(p,src);

	w->offset += len;
	
	return 0;	
}

int rtx_longstring_copy(RtxLongString * w, const char *src){
	w->offset = 0;
	return rtx_longstring_concat(w,src);
}


const char* rtx_longstring_content(RtxLongString* w){
	return w->str;
}

unsigned int rtx_longstring_length(RtxLongString* w){
	return w->offset;
}

int rtx_longstring_set_length(RtxLongString* w,unsigned int length){
	w->offset = MIN(w->size,length);
	w->str[w->offset] = 0;
	return 0;
}


char* rtx_longstring_buffer(RtxLongString* w){
	return w->str;
}

unsigned int rtx_longstring_size(RtxLongString* w){
	return w->size;
}

void rtx_longstring_destroy(RtxLongString *w){

	free(w->str);
	free(w);
}


