#!/usr/bin/wish
#
# srpc.tcl - Tcl client functions for RTX SRPC module
#
# CSIRO MANUFACTURING SCIENCE & TECHNOLOGY
# QCAT, PO Box 883, Kenmore, Q 4068, Australia
#
# $Id: srpc.tcl 935 2005-12-01 05:29:36Z pra077 $
#
# $Log$
# Revision 1.3  2005/12/01 05:29:36  pra077
# Point wish to the correct location (no longer /usr/local/bin...)
#
# Revision 1.2  2003/02/13 05:42:17  sik057
# Updated to make SRPC behave like RTC.
#
# Revision 1.1  2002/11/04 06:51:10  sik057
# Added inet, srpc and string modules
#
#
#
# Copyright (c) CSIRO Manufacturing Science & Technology
#

set rtx_srpc_next_channel_id 0
set rtx_srpc_channels(0) 0

# init socket connection

proc rtx_srpc_initconn {host port} { 
    global rtx_srpc_next_channel_id rtx_srpc_channels
    
    set portnum [expr $port + 64000]
    if { [catch {socket $host $portnum} channelId] } {
	error $channelId
    }
    set myChannelId $rtx_srpc_next_channel_id
    set rtx_srpc_channels($rtx_srpc_next_channel_id) [list $channelId $host $port]
    set rtx_srpc_next_channel_id [expr $rtx_srpc_next_channel_id + 1]
    return $myChannelId
}

# make srpc call

proc rtx_srpc_call {channelId msg} { 
    global rtx_srpc_channels

    # puts "rtx_srpc_call: $rtx_srpc_channels($channelId)"
    set myChannel [lindex $rtx_srpc_channels($channelId) 0]
    if {$myChannel == -1} {
	set myHost [lindex $rtx_srpc_channels($channelId) 1]
	set myPort [lindex $rtx_srpc_channels($channelId) 2]
	set portnum [expr $myPort + 64000]
	# puts "rtx_srpc_call: reopening channel ($myHost:$myPort $portnum)"
	if {[catch {socket $myHost $portnum} myChannel] == 0} {
	    set rtx_srpc_channels($channelId) [list $myChannel $myHost $myPort]
	    # puts "rtx_srpc_call: reopened channel"
	} else {
	    # puts "rtx_srpc_call: return $errCode"
	    error $errCode
	}
    }
    if {[catch { 
	        puts $myChannel "$msg \n"
	        flush $myChannel
	        gets $myChannel dataLast
               } errCode]} {
        close $myChannel
	set myHost [lindex $rtx_srpc_channels($channelId) 1]
	set myPort [lindex $rtx_srpc_channels($channelId) 2]
	set rtx_srpc_channels($channelId) [list -1 $myHost $myPort]
	error $errCode
    }
    # puts "rtx_srpc_call: return $dataLast"
    return $dataLast
}

package provide RTX_SRPC 1.0
