# Python class to implement SRPC client.
#
#	srpc = SRPCClient.SRPCClient()
#	srpc.connect(host, prognum)
#	srpc.reconnect()
#	srpc.getHost()
#	srpc.getProgramNumber()
#	srpc.close()
#	srpc.call(function, arglist)
#
# pic april 2004
#
# $Log$
# Revision 1.1  2004/05/20 02:38:39  pic
# Python interface to SRPC, implements a client
#
# $Author: pic $
import string;
import socket;
import os.path;
import re;
import types;

class SRPCClient:

	def __init__(self, r="/usr/aa/etc"):
		root = r;

	def connect(self, host, num=0):

		h = host.split(':');
		if len(h) == 2:
			host = h[0];
			try:
				num = int(h[1]);
			except:
				fp = open( os.path.join(root,  "services.rtc"), "r");

				for l in fp:
					if len(l) == 0:
						continue;
					if l[0] == '#':
						continue;
					m = l.split();
					if m[0] == h[1]:
						num = m[1];
						break;

				fp.close();
					
				
		if num == 0:
			raise AttributeError, "no program number provided";
		self.programNumber = num;
		self.host = host;
		#self.socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM);
		self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM);
		self.socket.connect((host, num+64000));

	def reconnect(self):
		self.socket.close();
		self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM);
		print "reconnect %s %d" %(self.host, self.programNumber)
		self.socket.connect((self.host, self.programNumber+64000));
		
	def getHost(self):
		return self.host;

	def getProgramNumber(self):
		return self.programNumber;

	def close(self):
		self.host = None;
		self.num = None;
		self.socket.close();

	def call(self, func, *args):
		cmd = func + " ";

		# expand all list arguments and concatenate
		for a in args:
			if type(a) is types.ListType:
				for v in a:
					cmd = cmd + str(v) + " ";
			else:
				cmd = cmd + str(a) + " ";
		#print "command is <%s>" % cmd;
		self.socket.send(cmd + "\n");

		# deal with reply
		retval = self.socket.recv(8192);
		if re.match(retval, r'RTX_SRPC_ERROR'):
			raise ValueError, retval;

		retval = re.sub(r'(^\[)|(\]$)', '', retval);
		#print "retval is <%s>" % retval;
		return retval.split();

