# Python class to access exported variables
#
#	ev = ExportVarClient.ExportVarClient(host, prognum);
#	ev.list()
#	ev[i]     i'th exported variable object
#
#	v = ev.getVar(varname)
#	v.set(newval)
#	v.get()
#	v[k]    k'th element of vector variable
#	v.getVarName()
#	v.getVarDim()
#
#	v.setUserData(index, e):
#	v.getUserData(self, index):
#
#	ExportVarClient.batchRead(vlist)	batch read
#	ExportVarClient.batchReset(vlist)	reset batch read
#
# pic april 2004
#
#	$Author: pic $
#	$Log$
#	Revision 1.1  2004/05/20 02:38:53  pic
#	Python interface to exported variables.
#
#
import SRPCClient;
import re;

class ExportVar:

	def __init__(self, parent):
		self.parent = parent;
		self.userData = [];
		self.lastBatch = "";

	# return value of exported variable
	#
	#	eg. a.get()
	#
	def get(self):
		return self.getValue();

	# return value of exported variable
	#
	#	eg. a.get()
	#
	def getValue(self):
		if self.lastBatch:
			#print 'using batched value'
			r = self.lastBatch;
		else:
			r = self.parent.call("exportvar_var", self.varname);
		if self.numeric:
			if self.float:
				r = map(float, r);
			else:
				r = map(int, r);
		if len(r) == 1:
			r = r[0];
		return r;

	# return value of exported vector variable 
	#
	#	eg. a[1]
	#
	def __getitem__(self, index):
		if index >= self.dim:
			raise IndexError;

		if self.lastBatch:
			#print 'using batched value'
			r = self.lastBatch[index];
		else:
			r = self.parent.call("exportvar_var", "%s[%d]" % (self.varname, index) );
			r = r[0];
		if self.numeric:
			if self.float:
				return float(r);
			else:
				return int(r);

	# return value of exported variable
	#
	#	eg. a.set(3)
	#
	def set(self, value):
		print self.varname, self.type, self.dim
		if self.dim > 1:
			if len(value) != self.dim:
				raise ValueError, "assigned vector wrong length"
		self.parent.call("exportvar_var", self.varname, value);

	# set value of exported vector variable 
	#
	#	eg. a[1] = 3
	#
	def __setitem__(self, index, value):
		if index >= self.dim:
			raise IndexError;
		self.parent.call("exportvar_var", "%s[%d]" % (self.varname, index), value);

	# get the name of this var
	def getVarName(self):
		return self.varname;
	
	# get the dimension of this var
	def getVarDim(self):
		return self.dim;

	def setVarBatch(self, val):
		self.lastBatch = val;

	def resetVarBatch(self):
		self.lastBatch = '';

	# stash a user object reference
	def setUserData(self, index, e):
		self.userData.insert(index, e);

	# retrieve a user object reference
	def getUserData(self, index):
		return self.userData[index];


def batchRead(*vars):
	vlist = [];

	for v in vars:
		vlist.append(v.getVarName() );
	
	parent = vars[0].parent;
	r = parent.call("exportvar_multi_var", ' '.join(vlist) );
	for v in vars:
		n = v.getVarDim();
		v.setVarBatch(r[0:n]);
		r = r[n:];

def batchReset(*vars):
	for v in vars:
		v.resetVarBatch();


class ExportVarClient(SRPCClient.SRPCClient):



	def __init__(self, host, num=0):

		self.varDict = {};

		self.connect(host, num);

		varlist = self.call("exportvar_list");

		numTypes = [ "short", "int", "long", "float", "double"];
		floatTypes = [ "float", "double"];

		for v in varlist:
			# remove dross from end of name
			m = re.match(r'[\w\._]+', v);
			v = m.group(0);

			# get the parameters of the variable
			info = self.call("exportvar_info", v);

			#print v, info
			var = ExportVar(self);
			var.varname = v;
			var.poll = info[0];
			var.ro = info[1];

			var.type = info[2];
			var.numeric = info[2] in numTypes;
			var.float = info[2] in floatTypes;

			var.dim = int(info[3]);
			if info[4] == '(null)':
				var.units = "";
			else:
				var.units = info[4];
			if len(info) > 5:
				var.minValue = info[5];
				var.maxValue = info[6];
				
			self.varDict[v] = var;

	def list(self):
		for v in self.varDict:
			info = self.varDict[v];

			if info.ro == 0:
				ro = '  '
			else:
				ro = 'RO'
			if info.poll == 0:
				poll = '   '
			else:
				poll = 'poll'
			print "%8s %-8s %d %s %s %s" % (v, info.type, info.dim, ro, poll, info.units) ;

	# create a reference to an exported var
	#
	#	a = export.getVar('a');
	def getVar(self, var):
		return self.varDict[var];

	def __getitem__(self, i):
		vars = self.varDict.keys();
		return vars[i];

	def __contains__(self, var):
		return var in self.varDict;

	def __len__(self):
		return len(self.varDict);

