/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: traj.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/

#ifndef RTX_TRAJ_H
#define RTX_TRAJ_H

#include <rtx/defines.h>

RTX_CXX_OPEN

typedef struct _rtx_traj_seg {
	double	*x;		/* target location */
	double	speed;		/* desired path speed */
	double	tacc;		/* acceleration time */
	double	accMax;		/* maximum allowed acceleration */
} RtxTrajSeg;

enum tstate {
	NOT_INITD = 0,
	IDLE,		/* no active path */
	ACC,		/* accelerating */
	CONSTVEL,	/* moving at constant velocity */
	STOPPING,
	STOPPED
};

typedef struct _rtx_traj {
	int		dim;		/* dimension of the state space */
	RtxTrajSeg	**seglist;	/* list of motion segments */
	int		nsegs;		/* number of segments */
	int		curseg;		/* index of current segment */
	double		tpath;		/* time along path */
	double		tsegmax;	/* time for current segment */
	double		tseg;		/* time for current segment */
	enum tstate	state;		/* motion state */
	double		speedFactor;
	double		*x;
	double		*xd;
	double		*x2;
	double		*xd2;
        RtxQuintic	*q;	/* quintic used for accelerating blending */
} RtxTraj;

RtxTraj * rtx_traj_init(RtxTraj *t, int dim);
int rtx_traj_eval(RtxTraj *t, double dt);
int rtx_traj_append(RtxTraj *t, double *x, double speed, double tacc, double accMax);
void rtx_traj_print(FILE *fp, RtxTraj *t);

RTX_CXX_CLOSE

#endif /* RTX_TRAJ_H */

