/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: time.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file time.h
 * \brief time-related functions
 * \author Jonathan Roberts and Pavan Sikka
 *
 ********************************************************************
 */

#ifndef RTX_TIME_H
#define RTX_TIME_H

#include <rtx/defines.h>

RTX_CXX_OPEN

typedef struct _rtx_time {
    long      seconds;
    long      nanoSeconds;
} RtxTime;

int rtx_time_get (RtxTime * tp);
double rtx_time_get_delta (RtxTime * tp0);

double rtx_time_to_double (RtxTime *tp);
void rtx_time_from_double (RtxTime *tp, double t);

void rtx_time_add ( RtxTime *result, RtxTime *t1, RtxTime *t2);
void rtx_time_subtract ( RtxTime *result, RtxTime *t1, RtxTime *t2);
double rtx_time_subtract_to_double (RtxTime * tp1, RtxTime * tp2);
int rtx_time_cmp (RtxTime *t1, RtxTime *t2);
int rtx_time_conv_date_time (char * buf, int len, char * prefix,
			     char * sep, char * suffix, RtxTime * ts);
int rtx_time_conv_sec_nsec (char * buf, int len, char * prefix,
			     char * sep, char * suffix, RtxTime * ts);

RTX_CXX_CLOSE

#endif /* RTX_TIME_H */
