/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: sync.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file sync.c
 * \brief A simple interface to synchronization using cond vars
 * \author Pavan Sikka
 *
 ********************************************************************
 */

#ifndef RTX_SYNC_H
#define RTX_SYNC_H

#include <pthread.h>

#include <rtx/mutex.h>
#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * The RTX sync type
 */
typedef struct _rtx_sync {
    RtxMutex		mutex;
    pthread_cond_t	cond;
    int                 count;
    int                 memAlloc;
} RtxSync;

RtxSync *rtx_sync_init (RtxSync * sync, int mutexAttrs, int prio,
			int condAttrs);
int rtx_sync_destroy (RtxSync * p);
int rtx_sync_wait (RtxSync * p);
int rtx_sync_timedwait (RtxSync * p, double timeout);
int rtx_sync_unlock (RtxSync * p);
int rtx_sync_broadcast (RtxSync * p);
int rtx_sync_signal (RtxSync * p);

RTX_CXX_CLOSE

#endif /* RTX_SYNC_H */


