/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: stats.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file stats.h
 * \brief Mathematical utility functions
 * \author Peter Corke and Jonathan Roberts
 *
 ********************************************************************
 */

#ifndef RTX_STATS_H
#define RTX_STATS_H

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * simple statistics data structure
 */
typedef struct _stats {
	unsigned int	n;		/**< number of samples */
	double		sumx,		/**< sum */
			sumx2,		/**< sum of squares */
			min,		/**< minimum so far */
			max;		/**< maximum so far */
        unsigned       *histbuf;       /**< buffer for histogram */
	int             nbins;          /**< length of histogram buffer */
	double          hmin;           /**< minimum value for histogram */
	double          hwidth;         /**< width of histogram bin */

	/* results section */
	double		mean;
	double		var;
	double		std;
	double		med;
	int		nnans;

} RtxStats;

void rtx_stats_update (RtxStats *s, double v);
void rtx_stats_init (RtxStats *s);
int rtx_stats_init_histogram (RtxStats *s, double hmin, double hwidth, int nbins);
int rtx_stats_mean (RtxStats *s, double *mean);
int rtx_stats_variance (RtxStats *s, double *var);
int rtx_stats_median (RtxStats *s, double *var);
int *rtx_stats_histogram_get (RtxStats *s);
void rtx_stats_print (RtxStats *s);
void rtx_stats_fprint (FILE *fp, RtxStats *s);
void rtx_stats_routine (RtxStats *s);

void rtx_stats_result(RtxStats *s);

int rtx_stats_min_double (double *data, int nPoints, double *min);
int rtx_stats_max_double (double *data, int nPoints, double *max);

RTX_CXX_CLOSE

#endif /* RTX_STATS_H */
