/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: srpc.h 2296 2008-01-03 05:54:51Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file srpc.h
 * \brief a simple interface for Tcl/Tk GUIs
 * \author Pavan Sikka
 *
 * RTC replacement
 *
 ********************************************************************
 */

#ifndef RTX_SRPC_H
#define RTX_SRPC_H

#include <rtx/defines.h>
#include <rtx/hash.h>
#include <rtx/inet.h>

RTX_CXX_OPEN

#define RTX_SRPC_PORT_OFFSET     64000

typedef int (* RtxSrpcHandler) (char * buf, int len, int argc, char * argv[]);

typedef struct _rtx_srpc {
    RtxInet * server;
    rtx_hash_t ht;
} RtxSrpc;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

RtxSrpc * rtx_srpc_init (int port);
int rtx_srpc_register (RtxSrpc * p, char * name, RtxSrpcHandler func);
int rtx_srpc_done (RtxSrpc * p);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

RTX_CXX_CLOSE

#endif /* RTX_SRPC_H */


