/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: socket.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/

#ifndef RTX_SOCKET_H
#define RTX_SOCKET_H

#include <rtx/defines.h>

RTX_CXX_OPEN

#define RTX_MAX_NAME_LEN        64
#define RTX_MAX_ADDR_LEN        128    

#define RTX_UDP_SEND	1
#define RTX_UDP_RECV 	0
 
/**
 * RTX socket structure 
 */

typedef struct _rtx_com {
        int     sockfd;         /*!< Socket handle */
	int     multicast;      /*!< Whether socket is multicast */
     	int     portNum;
        char    hostname[RTX_MAX_NAME_LEN];
        char    addr[RTX_MAX_ADDR_LEN]; 
    	int     addrLen;
	} RtxSocket;        

#ifndef DOXYGEN_SHOULD_SKIP_THIS

RtxSocket *rtx_socket_open( int portNum, char *hostname, int);
int   rtx_socket_close( RtxSocket *com);
int   rtx_socket_send( RtxSocket *com, char * buf, int len);
int   rtx_socket_recv( RtxSocket *com, char *buf, int len);
char *rtx_socket_print_host_addr ( RtxSocket *com);
int   rtx_socket_print_host_port ( RtxSocket *com);

#endif

RTX_CXX_CLOSE

#endif /* RTX_SOCKET_H */
