/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: signal.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file signal.h
 * \brief simple signal interface
 * \author Pavan Sikka
 *
 *
 ********************************************************************
 */

#ifndef RTX_SIGNAL_H
#define RTX_SIGNAL_H

#include <signal.h>

#include <rtx/defines.h>

RTX_CXX_OPEN

#ifndef DOXYGEN_SHOULD_SKIP_THIS

int rtx_signal_ignore (int sigNum);
int rtx_signal_block (int sigNum);
int rtx_signal_unblock (int sigNum);
int rtx_signal_block_realtime (void);
int rtx_signal_unblock_realtime (void);
int rtx_signal_alloc_realtime (void);
int rtx_signal_free_realtime (int sigNum);

#endif

RTX_CXX_CLOSE

#endif /* RTX_SIGNAL_H */
