/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: serial.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file serial.h
 * \brief Serial data handling functions
 * \author Peter Corke
 *
 ********************************************************************
 */

#ifndef RTX_SERIAL_H
#define RTX_SERIAL_H

#include <rtx/defines.h>
#include <rtx/time.h>
#include <rtx/thread.h>

RTX_CXX_OPEN

typedef enum {
    RTX_SERIAL_PARITY_NOP,
    RTX_SERIAL_PARITY_NONE,
    RTX_SERIAL_PARITY_ODD,
    RTX_SERIAL_PARITY_EVEN
} RtxSerialParity;

typedef enum {
    RTX_SERIAL_MODEM_NOP,
    RTX_SERIAL_MODEM_ON,
    RTX_SERIAL_MODEM_OFF
} RtxSerialModem;

typedef enum {
    RTX_SERIAL_FLOW_NOP,
    RTX_SERIAL_FLOW_NONE,
    RTX_SERIAL_FLOW_XONXOFF,
    RTX_SERIAL_FLOW_HW
} RtxSerialFlow;

int rtx_serial_open (char *dev, int baud, int databits, int stopbits, 
		     RtxSerialParity parity, RtxSerialFlow flow, 
		     RtxSerialModem modem, int vmin, int vtime);

int rtx_serial_open_with_prio (char *dev, int baud, int databits, int stopbits, 
		     RtxSerialParity parity, RtxSerialFlow flow, 
		     RtxSerialModem modem, int vmin, int vtime, RtxThreadPrio prio);
int rtx_serial_close( int fd );

int rtx_serial_read (int fd, char *data, int n);
int rtx_serial_read_timeout (int fd, char *data, int n, double timeout);
int rtx_serial_read_vtimeout (int fd, char *data, int n);
int rtx_serial_read_until (int fd, char *data, int n, char * pat, int patlen);
int rtx_serial_read_skip (int fd, char * pat, int patlen);
int rtx_serial_read_packet(int fd, char *data, int pktlen, 
			   char * headerPat, int headerLen, RtxTime *ts);

int rtx_serial_enable_receiver (int fd);
int rtx_serial_disable_receiver (int fd);
int rtx_serial_flush_input (int fd);
int rtx_serial_flush_output (int fd);

int rtx_serial_set_baudrate (int fd, int readbaud, int writebaud);
int rtx_serial_set_databits (int fd, int databits);
int rtx_serial_set_stopbits (int fd, int stopbits);
int rtx_serial_set_parity (int fd, RtxSerialParity parity);
int rtx_serial_set_flowcontrol (int fd, RtxSerialFlow flow);
int rtx_serial_set_modemcontrol (int fd, RtxSerialModem modem);

int rtx_serial_crc16 (unsigned char *p, int n);

RTX_CXX_CLOSE

#endif /* RTX_SERIAL_H */
