/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: sem.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file sem.h
 * \brief A simple interface to semaphores
 * \author Pavan Sikka
 *
 ********************************************************************
 */

#ifndef RTX_SEM_H
#define RTX_SEM_H

#include <semaphore.h>

#include <rtx/defines.h>

RTX_CXX_OPEN

typedef struct _rtx_sem {
	sem_t id;
	int sysvid;		/*!< Semaphore ID */
	int     memAlloc;       /*!< set if memory obtained dynamically */
} RtxSem;

RtxSem *rtx_sem_init (RtxSem * sem, int pshared, unsigned int initValue);
int rtx_sem_destroy (RtxSem * sem);
int rtx_sem_wait (RtxSem * sem);
int rtx_sem_timedwait (RtxSem * sem, double timeout);
int rtx_sem_wait_ignore_eintr (RtxSem * sem);
int rtx_sem_timedwait_ignore_eintr (RtxSem * sem, double timeout);
int rtx_sem_post (RtxSem * sem);
int rtx_sem_post_binary (RtxSem * sem, int value);

RTX_CXX_CLOSE

#endif /* RTX_SEM_H */


