/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: scircbuff.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/

#ifndef SCIRC_BUFFER_H
#define SCIRC_BUFFER_H

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * This structure represent a circular buffer of strings
 * Useful to remember only the last of a set of logs
 */

typedef struct {
	unsigned int size;           /* size of the buffer */
	unsigned int indexW;         /* where to write */
	unsigned int indexR;         /* where to read */
	char **buffer;               /* storage for the strings */
	int empty;                   /* 1 one the buffer is empty */
	int alloc;                   /* 1 if the object has been malloc'd */
} RtxCircularStringBuffer;

/** Initialise the buffer
 * @param self: a pointer to an existing buffer, if null, the object is
 * malloc'd internally
 * @param size: the size of the buffer
 * */
RtxCircularStringBuffer* rtx_csbuffer_init(RtxCircularStringBuffer * self, unsigned int size);

/** Test if the buffer is empty */
int rtx_csbuffer_is_empty(RtxCircularStringBuffer* log);

/** Test if the buffer is full */
int rtx_csbuffer_is_full(RtxCircularStringBuffer* log);

/** return how many string are stored in the buffer */
int rtx_csbuffer_used_size(RtxCircularStringBuffer* log);

/** return how many string are available in the buffer */
int rtx_csbuffer_free_size(RtxCircularStringBuffer* log);

/** clear the buffer */
int rtx_csbuffer_clear(RtxCircularStringBuffer* log);

/** remove the top strinf from the buffer */
int rtx_csbuffer_pop(RtxCircularStringBuffer* log);

/** push a string on the buffer */
int rtx_csbuffer_push(RtxCircularStringBuffer* log,const char * message);

/** get the string on top of the buffer */
char* rtx_csbuffer_front(RtxCircularStringBuffer* log);

/** Debug tool: make a printf dump of the buffer state **/
int rtx_csbuffer_dump(RtxCircularStringBuffer* log);

/** Delete the strings in the buffer. If the buffer was
 * initially allocated, it is also freed */
void rtx_csbuffer_destroy(RtxCircularStringBuffer* log);

RTX_CXX_CLOSE

#endif /* SCIRC_BUFFER_H */

