/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: quintic.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/

#ifndef	RTX_QUINTIC_H
#define	RTX_QUINTIC_H

#include <rtx/defines.h>

RTX_CXX_OPEN

typedef
	struct _quintic {
		double	A, B, C, D, E, F;
		double	tmax;
	}
RtxQuintic;

void rtx_quintic_init(RtxQuintic *q, double tmax, double q0, double q1,
	double qd0, double qd1);
double rtx_quintic_evaluate(RtxQuintic *q, double t, int *flag);
void rtx_quintic_evaluate2(double *p, double *v, RtxQuintic *q, double t);
void rtx_quintic_evaluate3(double *p, double *v, double *a, RtxQuintic *q, double t);

RTX_CXX_CLOSE

#endif /* RTX_QUINTIC_H */
