/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: pid.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/


#ifndef	RTX_PID_H
#define	RTX_PID_H

#include <rtx/defines.h>
#include <rtx/param.h>

RTX_CXX_OPEN

typedef struct _pid_loop {
	char	*name;		/* name of this axis */
	char	*units;		/* name of units */
	int	verbose;

	int	dtime;		/* last demand time */
	int	atime;
	
	int	enabled;	/* loop is enabled */

	/*
	 * demand generation is embedded in the control loop
	 */
	double	dmd;		/* current demanded output value */
	double	dmd2;		/* demand used by ramp generator */
	double	dmd_rate;	/* demand rate of change (units/s) */
	double	dmd_goal;	/* desired demand */
	double	dmd_prev;	/* previous demand */
	
	/*
	 * control parameters
	 */
	double	P;		/* proportional gain */
	double	Kff;		/* feedforward gain */
	double	I;		/* integral gain */
	double	D;		/* derivitive gain */
	double	min, max;	/* output limits */
	double	Imin, Imax;	/* integral limits */
	double	ratelimit;	/* input rate limit (units/s) */
	double	deadband;	/* deadband applied to error */
	double	offset;		/* output offset */
	double	intband;	/* band for integral action */

	/*
	 * state
	 */
	double	integral;	/* the integrator state */
	double	prev;
	double	error;		/* current error */
	double	e_prev;		/* previous error */

	int	Ienable;	/* enable integral action */
	int	level;
	double	dt;
	double	feedback;	/* the plant output */
} RtxPid;


RtxPid	*rtx_pid_init(RtxPid *P, RtxParamStream *pf, char *name, double dt, int verbosity);
double rtx_pid_eval(RtxPid *P, double y, double ystar, double ystar_d);
void rtx_pid_integral_reset(RtxPid *P);
void	rtx_pid_integral_enable(RtxPid *P);
void	rtx_pid_integral_disable(RtxPid *P);
int rtx_pid_export(RtxPid *P);
void rtx_pid_reset(RtxPid *P);

RTX_CXX_CLOSE

#endif /* RTX_PID_H */
