/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: param.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file param.c
 * \brief Parameter access module
 * \author Peter Corke
 *
 ********************************************************************
 */

#ifndef RTX_PARAM_H
#define RTX_PARAM_H

#include <rtx/defines.h>
#include <rtx/list.h>

RTX_CXX_OPEN

#include <stdio.h>

typedef struct _paramfile RtxParamStream;
/**
 * parameter file datatype
 */
struct _paramfile {
	FILE	*fp;		  /**< pointer for input stream. */
	int	verbose;	  /**< verbose if > 0. */
        int     usePreprocessor;  /**< flag to indicate that the stream is being
				 ** filtered through the C preprocessor */
	void	(* errfunc)(const char *name, const char * err);
		                  /**< pointer to function to call on error. */
	char *	(* param_get_line)(RtxParamStream *fp, char *b, const char *param, int n);
		                  /**< pointer to function to return next 
				   ** parameter from stream. */
        RtxList * lines;          /**< a list of all the valid param lines,
				   **  searchable by first token (param name) */
};

RtxParamStream * rtx_param_open (const char *fname, int verb, 
			       void (* errfunc)(const char *name, const char *err) );
RtxParamStream * rtx_param_open_preprocessed (const char *fname, int verb, 
			       void (* errfunc)(const char *name, const char *err), int ac, char * av[] );
int rtx_param_get_double (RtxParamStream *pf, const char *param, double *p, int n);
int rtx_param_get_float (RtxParamStream *pf, const char *param, float *p, int n);
int rtx_param_get_int (RtxParamStream *pf, const char *param, int *p, int n);
int rtx_param_get_short (RtxParamStream *pf, const char *param, short *p, int n);
char * rtx_param_get_string (RtxParamStream *pf, const char *param, char *p, int n);
void rtx_param_close (RtxParamStream *pf);

RTX_CXX_CLOSE

#endif /* RTX_PARAM_H */


