/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: nmea.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file nmea.h
 * \brief Handler for NMEA based communications
 * \author Craig Worthington
 *
 ********************************************************************
 */

#ifndef RTX_NMEA_H
#define RTX_NMEA_H

#include <rtx/defines.h>
#include <rtx/mutex.h>
#include <rtx/serial.h>
#include <rtx/time.h>
#include <rtx/list.h>

RTX_CXX_OPEN

typedef struct _nmeatype
{
  RtxTime  timeStamp;        /* time mesg recieved */
  char     nmeaMesg[82];     /* current NMEA message */
  unsigned int numFields;
  char *   nmeaField[82];

  RtxMutex *nmeaMesgMutex;  /* protect gps data corruption */
} RtxNMEA;



int rtx_nmea_read( int port, RtxNMEA *mesg );
int rtx_nmea_write( int port, ... );
int rtx_nmea_read_buffer( char *buffer, unsigned int len, RtxNMEA *mesg );
int rtx_nmea_write_buffer( char buffer[82], ... );

int rtx_nmea_extract( RtxNMEA *mesg, int fieldNo, char *value );
int rtx_nmea_extract_short( RtxNMEA *mesg, int fieldNo, short *value );
int rtx_nmea_extract_int( RtxNMEA *mesg, int fieldNo, int *value );
int rtx_nmea_extract_float( RtxNMEA *mesg, int fieldNo, float *value );
int rtx_nmea_extract_double( RtxNMEA *mesg, int fieldNo, double *value );

/* int write(int fd, char *buff, int count ); */

RTX_CXX_CLOSE

#endif /* RTX_NMEA_H */


