/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: mutex.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file mutex.h
 * \brief A simple interface to mutexes
 * \author Pavan Sikka
 *
 ********************************************************************
 */

#ifndef RTX_MUTEX_H
#define RTX_MUTEX_H

#include <pthread.h>

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * The RTX mutex type
 */
typedef struct _rtx_mutex {
    pthread_mutex_t mutex;
    int memAlloc;
    char	*name;
    int		trace;
} RtxMutex;

#define RTX_MUTEX_DEFAULT            0x00
#define RTX_MUTEX_PROCESS_SHARED     0x01
#define RTX_MUTEX_PRIO_INHERITANCE   0x02
#define RTX_MUTEX_PRIO_CEILING       0x04

enum _rtx_mutex_debug_op {
	RTX_MUTEX_DEBUG_INIT = 1,	
	RTX_MUTEX_DEBUG_DESTROY,
	RTX_MUTEX_DEBUG_UNLOCK,
	RTX_MUTEX_DEBUG_LOCK_REQUEST,
	RTX_MUTEX_DEBUG_LOCK_GRANTED
};

RtxMutex *rtx_mutex_init (RtxMutex * mutex, int mutexAttrs, int prio);
RtxMutex *rtx_mutex_init2 (char *name, RtxMutex * mutex, int mutexAttrs, int prio);
int rtx_mutex_destroy (RtxMutex * mutexPtr);
int rtx_mutex_lock (RtxMutex * mutexPtr);
int rtx_mutex_unlock (RtxMutex * mutexPtr);

void rtx_mutex_debug(int enable);
void rtx_mutex_debug_set_callback(void (*func)(RtxMutex *m, enum _rtx_mutex_debug_op op));


RTX_CXX_CLOSE

#endif /* RTX_MUTEX_H */


