/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: message.h 3066 2008-05-15 02:08:15Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file message.h
 * \brief Message daemon functions
 * \author Jonathan Roberts
 *
 * Functions used to send messages to the message daemon.
 *
 ********************************************************************
 */

#ifndef RTX_MESSAGE_H
#define RTX_MESSAGE_H

#include <stdio.h>
#include <stdarg.h>

#include <rtx/defines.h>
#include <rtx/time.h>

RTX_CXX_OPEN

#define ERROR                   -1
#define RTX_MESSAGE_MQ_NAME     "messagedIn"
#define RTX_MESSAGE_FIFO_PATH   "/tmp/messaged_fifo"

#define RTX_MESSAGE_SIZE        1024

#define err(x)  if ((x) < 0) return ERROR;
#define perr(x) if ((x) == NULL) return ERROR;
 
typedef enum {
        RTX_MESSAGE_ERR = 1,
        RTX_MESSAGE_WARNING,
        RTX_MESSAGE_SHUTDOWN
} RtxMessageErrorType;

/*
 * This is the message queue structure
 */
typedef struct _messaged_msg_in {
        RtxMessageErrorType     type;
        RtxTime         	timestamp;
        char            	string[RTX_MESSAGE_SIZE];
} RtxMessage;

#define	RTX_MESSAGE_STDERR		1
#define	RTX_MESSAGE_STDOUT		2
#define	RTX_MESSAGE_MESSAGE		4
#define	RTX_MESSAGE_SYSLOG		8
#define	RTX_MESSAGE_CUSTOM		16

typedef void (*RtxMessageCustomFunc)(const char *);

void rtx_message_init(const char *pname, int destination);
void rtx_message_set_custom_destination(RtxMessageCustomFunc f);
void rtx_message(const char *fmt, ...);
void rtx_message_routine(const char *fmt, ...);
void rtx_message_warning(const char *fmt, ...);
void rtx_message_error(const char *fmt, ...);
void rtx_message_rtx_error(RtxTime * tp, const char *msg);
void rtx_message_shutdown(const char *fmt, ...);
void rtx_message_argv(int ac, char **av);

/* deprecated functions */
void rtx_message_set_pname(const char *name);
void rtx_message_local(void);
void rtx_message_global(void);

RTX_CXX_CLOSE

#endif /* RTX_MESSAGE_H */
