/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: matrix.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file matrix.h
 * \brief Matrix manipulation functions
 * \author Peter Corke
 *
 ********************************************************************
 */

#ifndef RTX_MATRIX_H
#define RTX_MATRIX_H

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * Matrix structure.
 */
typedef struct _mat {
	int	rows,	/**< number of rows in Matrix. */
		cols;	/**< number of columns in Matrix. */
	double	**r;	/**< pointer to Matrix data. */
} RtxMatrix;

RtxMatrix * rtx_matrix_load_matlab_file (char *file, char *matname);
RtxMatrix * rtx_matrix_new (int rows, int cols);
void rtx_matrix_free (RtxMatrix *m);
void rtx_matrix_mult (RtxMatrix *p, RtxMatrix *a, RtxMatrix *b);
void rtx_matrix_add (RtxMatrix *s, RtxMatrix *a, RtxMatrix *b);
void rtx_matrix_fprint (FILE *fp, RtxMatrix *s);
void rtx_matrix_print (RtxMatrix *s);

RTX_CXX_CLOSE

#endif /* RTX_MATRIX_H */


