/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: main.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file main.h
 * \brief Startup/shutdown helper functions
 * \author Jonathan Roberts and Pavan Sikka
 *
 ********************************************************************
 */

#ifndef RTX_MAIN_H
#define RTX_MAIN_H

#include <rtx/defines.h>
#include <rtx/thread.h>

RTX_CXX_OPEN

#ifndef DOXYGEN_SHOULD_SKIP_THIS

int
rtx_main_init (const char * appName, int msgDest);
int rtx_main_wait_shutdown (RtxThreadPrio prio);
int rtx_main_signal_shutdown (void);
char * rtx_main_signal_rtc_shutdown (int argc, char * argv[]);
int rtx_main_signal_srpc_shutdown (char * buf, int len, int argc, char * argv[]);
int rtx_main_signal_launcher (void);

#endif

RTX_CXX_CLOSE

#endif /* RTX_MAIN_H */
