/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: longstring.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/

#ifndef RTX_LONGSTRING_H
#define RTX_LONGSTRING_H

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * LongString structure is used to do string operations
 */
typedef struct {
	char * str;
	unsigned int size;
	unsigned int offset;
} RtxLongString;


/** Initialise an empty string */
RtxLongString* rtx_longstring_init();

/** Empty the string */
int rtx_longstring_clear(RtxLongString * w);

/** Empty the string, and release memory */
int rtx_longstring_reset(RtxLongString * w);

/** Reserve some memory the string */
int rtx_longstring_reserve(RtxLongString * w,unsigned long size);

/** Add a string at the end of the string */
int rtx_longstring_concat(RtxLongString * w, const char *src);

/** Copy a string in the string, overwriting existing src */
int rtx_longstring_copy(RtxLongString * w, const char *src);

/** Returns the C content of the string */
const char* rtx_longstring_content(RtxLongString* w);

/** Returns the length of the string, not counting the last zero */
unsigned int rtx_longstring_length(RtxLongString* w);


/** Returns the allocated size of the string*/
unsigned int rtx_longstring_size(RtxLongString* w);

/** Free the resources allocated to the string */
void rtx_longstring_destroy(RtxLongString *w);

/******************************
 * WARNING: the two following functions are mostly for internal use
 * They don't garantee that the state of the object stays consistent over time
 * ***************************/

/** Returns a pointer to the internal buffer of the string.
 * Can be used after the string has been reserved.*/
char* rtx_longstring_buffer(RtxLongString* w);

/** Define the length of the string, not counting the last zero.
 * To be used when the string has been modified through its buffer.
 * The desired length is clipped to the actual size of the string.
 * */
int rtx_longstring_set_length(RtxLongString* w, unsigned int length);

RTX_CXX_CLOSE

#endif /* RTX_LONGSTRING_H */

