/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: list.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file list.h
 * \brief Doubly-linked lists
 * \author Pavan Sikka
 *
 * Thread-safe (and thread-cancellation-safe) doubly-linked lists
 *
 ********************************************************************
 */

#ifndef RTX_LIST_H
#define RTX_LIST_H

#include <rtx/defines.h>
#include <rtx/mutex.h>

RTX_CXX_OPEN

typedef struct _rtx_list_node {
    void * d;
    char * name;
    struct _rtx_list_node * next;
    struct _rtx_list_node * prev;
} RtxListNode;

typedef struct _rtx_list {
    RtxListNode * head;
    RtxListNode * tail;
    RtxListNode * cur;
    int iterate;
    int n;
    RtxMutex mutex;
} RtxList;

RtxList * rtx_list_init (void);
int rtx_list_add (RtxList * list, const char * name, void * d);
void * rtx_list_del (RtxList * list, const char * name, int freeNode);
void * rtx_list_del_node (RtxList * list, void * nd, int freeNode);
void * rtx_list_lookup (RtxList * list, const char * name);
void * rtx_list_iterate (RtxList * list);
int rtx_list_push (RtxList * list, void * d);
void * rtx_list_pop (RtxList * list);
int rtx_list_enqueue (RtxList * list, void * d);
void * rtx_list_dequeue (RtxList * list);
void * rtx_list_peek_head (RtxList * list);
void * rtx_list_peek_tail (RtxList * list);
void rtx_list_destroy (RtxList * list, int freeNode);
void rtx_list_print (RtxList * list);

RTX_CXX_CLOSE

#endif /* RTX_LIST_H */


