/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: delay.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file delay.h
 * \brief Definitions for delayline module
 * \author Peter Corke
 *
 ********************************************************************
 */

#ifndef RTX_DELAY_H
#define RTX_DELAY_H

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * Delayline datastructure
 */
typedef struct _delay {
	double	*b;	/**< delayline buffer. */
	double	dt;	/**< sample interval. */
	int	i;	/**< index of insertion point into buffer. */
	int	n;	/**< length of the delayline (in samples.) */
} RtxDelay;

RtxDelay * rtx_delay_create(double tmax, double dt);
double rtx_delay_get (RtxDelay *d, double t);
void rtx_delay_put (RtxDelay *d, double x);

RTX_CXX_CLOSE

#endif /* RTX_DELAY_H */
