/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id$
 *
 ***********************************************************************/

#ifndef RTX_DEFINES_H
#define RTX_DEFINES_H


/* Used in headers to wrap C declarations for use by C++ programs */
#ifdef __cplusplus
#  define RTX_CXX_OPEN extern "C" {
#  define RTX_CXX_CLOSE }
#else
#  define RTX_CXX_OPEN
#  define RTX_CXX_CLOSE
#endif

/* Used at the declaration of types, functions or variables that are
   deprecated and will disapear at some point int time, GCC will warn
   at uses of deprecated declarations. */
#ifdef __GNUC__
#  define RTX_DEPRECATED __attribute__((deprecated))
#else
#  define RTX_DEPRECATED
#endif

/* Used by functions that take format strings and varags so that the
   compiler can check passed arguments. */
#ifdef __GNUC__
#  define RTX_FORMAT(archetype, formatStringIndex, firstVarArgIndex) \
  __attribute__((format (archetype, formatStringIndex, firstVarArgIndex)))
#else
#  define RTX_FORMAT(archetype, formatStringIndex, firstVarArgIndex)
#endif

/* When used with a variable declaration, stops GCC complaining if the variable
   is not used. */
#ifdef __GNUC__
#  define RTX_UNUSED __attribute__((unused))
#else
#  define RTX_UNUSED
#endif

/* When used with a function declaration, makes GCC warn of users of
   the function that don't do something with the return result; great for
   forcing people to check error codes. */
#ifdef __GNUC__
#  define RTX_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
#  define RTX_WARN_UNUSED_RESULT
#endif

/* Commonly defined incorrectly. */
#define RTX_MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define RTX_MAX(X,Y) ((X) > (Y) ? (X) : (Y))



#endif /* RTX_DEFINES_H */
