/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: cond.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file mutex.h
 * \brief A simple interface to mutexes
 * \author Pavan Sikka
 *
 ********************************************************************
 */

#ifndef RTX_COND_H
#define RTX_COND_H

#include <pthread.h>

#include <rtx/defines.h>

RTX_CXX_OPEN

/**
 * The RTX cond type
 */
typedef struct _rtx_cond {
    RtxMutex		mutex;
    pthread_cond_t	cond;
    int 		(* func) (void * arg);
    void 		*arg;
    int                 memAlloc;
} RtxCond;

RtxCond *rtx_cond_init (RtxCond * cond, int mutexAttrs, int prio,
			 int condAttrs, 
			 int (* func) (void * arg),
			 void * arg);
int rtx_cond_destroy (RtxCond * p);
int rtx_cond_wait (RtxCond * p);
int rtx_cond_timed_wait (RtxCond * p, double timeout);
int rtx_cond_broadcast (RtxCond * p);
int rtx_cond_signal (RtxCond * p);

RTX_CXX_CLOSE

#endif /* RTX_COND_H */


