/*
 ********************************************************************
 *
 * circbuf.h - circular buffer
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *	$Id: circbuf.h 3129 2008-05-19 06:11:05Z roy029 $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file circbuf.h
 * \brief circular buffer
 * \author Pavan Sikka
 *
 ********************************************************************
 */

#ifndef __rtx_circbuf_h__
#define __rtx_circbuf_h__

#include <rtx/sem.h>
#include <rtx/thread.h>

typedef struct _rtx_circbuf {
    int n;
    int eSize;
    void * (* refill_fn) (void *);
    void * refillArg;
    int refillThPrio;
    int refillThreashold;
    char * front;
    char * back;
    char * lastElem;
    int numInBuf;
    RtxSem * sem;
    RtxThread * th;
    char * d;
} RtxCircbuf;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

RtxCircbuf * rtx_circbuf_init (int n, int elSize, void * (* refill_fn) (void *),
			       void * refillArg, int refillThPrio,
			       int refillThreashold);
void * rtx_circbuf_get (RtxCircbuf * c);
void * rtx_circbuf_peek (RtxCircbuf * c);
int rtx_circbuf_next (RtxCircbuf * c);
int rtx_circbuf_put (RtxCircbuf * c, void * d, int n);
int rtx_circbuf_done (RtxCircbuf * c);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#endif


