/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: byte.h 2287 2007-12-24 04:11:30Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file byte.h
 * \brief Byte stream utility functions
 * \author Jonathan Roberts
 *
 ********************************************************************
 */

#ifndef RTX_BYTE_H
#define RTX_BYTE_H

#include <rtx/defines.h>

RTX_CXX_OPEN

/** convert to a signed integer */
#define	RTX_BYTE_SIGNED		0x0100
/** convert to an unsigned integer */
#define	RTX_BYTE_UNSIGNED	0x0200
/** least significant byte is first */
#define	RTX_BYTE_LSBFIRST	0x0400
/** most significant byte is first */
#define	RTX_BYTE_MSBFIRST	0x0800

int rtx_byte_to_int(long *v, unsigned char *p, int n, int flag);
int rtx_byte_crc16(unsigned char *p, int n);
unsigned int rtx_byte_crc16_2(unsigned char *p, int n);
void rtx_byte_swap_int(int *data);
void rtx_byte_swap_short(short *data);

RTX_CXX_CLOSE

#endif /* RTX_BYTE_H */
