/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

static char rcsid[] = "$Header$";

/**
 * \file getopt_ex.c
 * \brief example program for the command-line options processing module
 * \author Pavan Sikka
 *
 * A simple test/example program for the command-line options
 * processing module
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <rtx/getopt.h>

char * stereo = "stereo options";
char * motion = "motion options"; 
char * target = "target options";
int live = 0;
int printHelp = 0;
int disparity[2] = {1, 10};

RtxGetopt myOpts[] = {
  {"-stereo", "Display options for stereo module",
   {
     {RTX_GETOPT_STR, &stereo, "stereo"},
     RTX_GETOPT_END_ARG
   }
  },
  {"-motion", "Display options for motion module", 
   {
     {RTX_GETOPT_STR, &motion, "motion"},
     RTX_GETOPT_END_ARG
   }
  },
  {"-target", "Display options for target module", 
   {
     {RTX_GETOPT_STR, &target, "target"},
     RTX_GETOPT_END_ARG
   }
  },
  {"-live", "Take live video from frame grabber", 
   {
     {RTX_GETOPT_SET, &live, ""},
     RTX_GETOPT_END_ARG
   }
  },
  {"-disparity", "Set disparity range", 
   {
     {RTX_GETOPT_INT, &disparity[0], "lower"},
     {RTX_GETOPT_INT, &disparity[1], "upper"},
     RTX_GETOPT_END_ARG
   }
  },
  RTX_GETOPT_END
};

char * helpStr = "This is a test string\n"
                 "second line";

int
main (int argc, char * argv[])
{
    int ret = -1;

    rtx_getopt_debug = 1;

    ret = RTX_GETOPT_CMD (myOpts, argc, argv, rcsid, helpStr);
    fprintf (stderr, "-------------------------------\n");
    fprintf (stderr, "test-getopt: return value = %d\n", ret);
    if (ret != -1)
        RTX_GETOPT_PRINT (myOpts, argv[0], rcsid, helpStr);
    return (0);
}
