/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <rtx/serial.h>
#include <rtx/timer.h>
#include <rtx/getopt.h>
#include <rtx/thread.h>
#include <rtx/main.h>

#include "svnversion.h"

#define DESCRIPTION "Reads data from one serial port and writes to another."

static char rcsid[] RTX_UNUSED = "$Id: serialrelay.c 2299 2008-01-05 13:03:22Z roy029 $";

int		baudRate = 38400;
char		*device = "/dev/ttyS0";
char		*device2 = "/dev/ttyS1";
RtxThread	*threadId;
RtxThread	*thread2Id;

int		fd, fd2;
int		flowOff = 0;
int		noBytes = 0, noBytes2 = 0;

RtxGetopt myOpts[] = {
	{"flowOff", "Turn hardware flow control off (default is on)", 
		{
			{RTX_GETOPT_SET, &flowOff, ""},
			RTX_GETOPT_END_ARG
		}
	},
	{"baudrate", "Serial baud rate", 
		{
			{RTX_GETOPT_INT, &baudRate, "baud rate"},
			RTX_GETOPT_END_ARG
		}
	},
	{"device", "Serial device", 
		{
			{RTX_GETOPT_STR, &device, "device"},
			RTX_GETOPT_END_ARG
		}
	},
	{"device2", "Serial device 2", 
		{
			{RTX_GETOPT_STR, &device2, "device2"},
			RTX_GETOPT_END_ARG
		}
	},
	RTX_GETOPT_END
};

void
reading_thread()
{
	int		nread;
	unsigned char	buf[12];

	while (1) {
		/* Read byte */
		if ((nread = rtx_serial_read(fd, (char*)buf, 1)) != 1) {
			continue;
		} else {
			noBytes++;

			/* Write byte */
			write(fd2, &buf[0], 1);
		}
	}
}

void
reading_thread2()
{
	int		nread;
	unsigned char	buf[12];

	while (1) {
		/* Read byte */
		if ((nread = rtx_serial_read(fd2, (char*)buf, 1)) != 1) {
			continue;
		} else {
			noBytes2++;

			/* Write byte */
			write(fd, &buf[0], 1);
		}
	}
}
int
main(int argc, char **argv)
{
	RtxSerialFlow	flow;

	RTX_GETOPT_CMD (myOpts, argc, argv, SVNVERSION, DESCRIPTION);

	/* Open serial port */
	fprintf(stderr, "Opening serial port %s...", device);
	if (flowOff)
		flow = RTX_SERIAL_FLOW_NONE;
	else
		flow = RTX_SERIAL_FLOW_HW;
	if ((fd = rtx_serial_open(device, baudRate, 8, 1,
			RTX_SERIAL_PARITY_NONE, flow,
			RTX_SERIAL_MODEM_OFF, 0, 1)) == -1) {
		fprintf(stderr, "rtx_serial_open() failed on %s\n", device);
		exit(1);
	}
	fprintf(stderr, "done\n");

	if ((fd = rtx_serial_open(device2, baudRate, 8, 1,
			RTX_SERIAL_PARITY_NONE, flow,
			RTX_SERIAL_MODEM_OFF, 0, 1)) == -1) {
		fprintf(stderr, "rtx_serial_open() failed on %s\n", device2);
		exit(1);
	}
	fprintf(stderr, "done\n");

	rtx_serial_flush_input(fd);
	rtx_serial_flush_output(fd);
	rtx_serial_flush_input(fd2);
	rtx_serial_flush_output(fd2);

	/* Launch reading thread */
	if ((threadId = rtx_thread_create(
			"reading_thread", 0,
			RTX_THREAD_SCHED_OTHER, 21, 0,
			RTX_THREAD_CANCEL_ASYNCHRONOUS,
			(void * (*)(void*))reading_thread, NULL,
			NULL, NULL)) == NULL) {
		fprintf(stderr, "rtx_thread_create() failed\n");
		exit(1);
	}

	/* Launch reading thread */
	if ((thread2Id = rtx_thread_create(
			"reading_thread2", 0,
			RTX_THREAD_SCHED_OTHER, 21, 0,
			RTX_THREAD_CANCEL_ASYNCHRONOUS,
			(void * (*)(void*))reading_thread2, NULL,
			NULL, NULL)) == NULL) {
		fprintf(stderr, "rtx_thread_create() failed\n");
		exit(1);
	}

	/* Wait to be killed */
	rtx_main_wait_shutdown(90);

	/* Cleanup */
	rtx_thread_destroy(threadId);
	rtx_thread_destroy(thread2Id);
	rtx_timer_sleep(0.2);
	rtx_serial_close(fd);
	rtx_serial_close(fd2);

	fprintf(stderr, "read %d bytes\n", noBytes);
	exit(0);
}
