/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

/**
 * \file routine.c
 * \brief Program to send a message through the message module
 * \author Jon Roberts
 *
 * This program reads the message specified on the command-line and sends
 * it to the message queue.
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include        <string.h>

#include "rtx/defines.h"
#include "rtx/message.h"

static char rcsid[] RTX_UNUSED = "$Id: routine.c 2274 2007-12-23 05:37:32Z roy029 $";

int
main(int ac, char *av[])
{
	char	b[BUFSIZ];

	b[0] = '\0';

	rtx_message_init ("routine", RTX_MESSAGE_STDERR |
			  RTX_MESSAGE_MESSAGE);

	/* concatenate all the command line arguments */
	while (--ac > 0) {
		strcat(b, *++av);
		strcat(b, " ");
	}

	rtx_message_routine("%s\n", b);
	exit(0);
}
