/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: messaged.h 2284 2007-12-24 00:20:48Z roy029 $
 *
 ***********************************************************************/
/**
 ********************************************************************
 *
 * \file messaged.h
 * \brief The header file for message daemon
 * \author jon Roberts
 *
 *
 ********************************************************************
 */

#include "config.h"


#ifndef __messaged_h
#define __messaged_h

#define INIT_MESSAGED_FILENAME	"messages"
#define INIT_MESSAGED_DIR	"/tmp"

#ifdef HAVE_MESSAGE_QUEUE
#include <mqueue.h>
#endif

#include "logMessage.h"

#include <rtx/httpd.h>
#include <rtx/scircbuff.h>

/*
 * This is the main messaged structure
 */
typedef struct _messaged {
    FILE           *logFile;
    time_t          logStart;
#ifdef HAVE_MESSAGE_QUEUE
    mqd_t           mqIn;
#else
    int             fifofd;
#endif
    char            mqInName[BUFSIZ];
    char           *dir;
    char           *archivedir;
    char           *fileName;
    int             confd;
    int             changePeriod;
    int             changeSize;
    int             currentSize;
    int             maxNumLogFiles;
    RtxMessage msgIn;
    char            hostString[128];
    char            **files;
    int             numLogFiles;
    int             curLogFileIndex;
    int		        webFlag;
    int		        webPort;
    int		        nofork;
    RtxHttpd	    *webserver;
	RtxMutex        *mutex;
    RtxCircularStringBuffer    *log;
    log_message     *logMess;
    
}
MESSAGED;

#endif
