/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <sys/stat.h>
#ifdef __linux__
#include <sys/file.h>
#include <libgen.h>
#else
#include <sys/lock.h>
#endif
#include <errno.h>
#include <signal.h>
#ifdef __sparc__
#include <libgen.h>
#endif
#include <dirent.h>

#include <rtx/message.h>
#include <rtx/error.h>
#include <rtx/thread.h>
#include <rtx/main.h>
#include <rtx/param.h>
#include <rtx/mutex.h>
#include <rtx/log.h>
#include <rtx/parse.h>
#include <rtx/signal.h>
#include <rtx/time.h>
#include <rtx/timer.h>
#include <rtx/getopt.h>
#include <rtx/list.h>
#include <rtx/longstring.h>


static char rcsid[] RTX_UNUSED = "$Id: messaged-webserver.c 2273 2007-12-23 04:50:57Z roy029 $";

#include "messaged-webserver.h"


static int get_archivefilelist(RtxHttpdReq * r){
	
	int n;
	unsigned int date, hour;
	int nb_arg;
	
	char filename[100]="";
	
	struct dirent **namelist;
	RtxLongString * xml;
	MESSAGED *messaged = (MESSAGED*)r->user_data;
	
	xml = rtx_longstring_init();
	
	rtx_mutex_lock(messaged->mutex);

	n = scandir(messaged->archivedir, &namelist, 0, alphasort);
	
	if (n < 0)
		perror("scandir");
	else {
		rtx_longstring_concat(xml, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
		rtx_longstring_concat(xml, "<!DOCTYPE logger SYSTEM \"./missionlist.dtd\">");
		rtx_longstring_concat(xml,"<message_archive_file_list archivedir=\"");
		rtx_longstring_concat(xml,messaged->archivedir);
		rtx_longstring_concat(xml,"\">");
		while(n--) {
			filename[0] = 0;
			nb_arg = sscanf(namelist[n]->d_name,"%u-%u-%99s",&date, &hour,filename);
			if((nb_arg == 3) && (strcmp(filename, "messages")==0)){
				rtx_longstring_concat(xml,"<file>");
				rtx_longstring_concat(xml,"<name>");
				rtx_longstring_concat(xml,namelist[n]->d_name);
				rtx_longstring_concat(xml,"</name>");
				rtx_longstring_concat(xml,"</file>");
			}
			free(namelist[n]);
		}
		rtx_longstring_concat(xml,"</message_archive_file_list>");
		
		free(namelist);

		
		if(rtx_httpd_reply_send_status(r, 200, NULL) != 0){
			rtx_longstring_destroy(xml);
			rtx_mutex_unlock(messaged->mutex);
			return rtx_error("Could not set HTTP response status");
		}

		if(rtx_httpd_reply_send_header(r, "Content-Type", "text/xml") != 0){
			rtx_longstring_destroy(xml);
			rtx_mutex_unlock(messaged->mutex);
			return rtx_error("Could not set Content Type");
		}

		if(rtx_httpd_reply_send_body(r,rtx_longstring_content(xml),
		   rtx_longstring_length(xml))!=0) {
			rtx_longstring_destroy(xml);
			rtx_mutex_unlock(messaged->mutex);
			return rtx_error("could not send response");
		}

		rtx_longstring_destroy(xml);
	}
	
	rtx_mutex_unlock(messaged->mutex);
	return 0;
}

static int download_file(RtxHttpdReq * r){
	
	char filename[100]="", tmp[512]="";
	MESSAGED *messaged = (MESSAGED*)r->user_data;
	
	sscanf(r->url,"/downloadfile/%99s", filename);
	
	if(strcmp(filename,"messages")==0){
		sprintf(tmp,"%s/%s", messaged->dir,messaged->fileName);	
	}else{
		sprintf(tmp,"%s/%s",messaged->archivedir,filename);
	}

	return rtx_httpd_send_file(r,tmp,"text/plain");
	
}

static int get_messagelog(RtxHttpdReq * r){
	const char * ptr;
	char defaultStr[] = "<messagelist></messagelist>";
	MESSAGED *messaged = (MESSAGED*)r->user_data;

	if(rtx_httpd_reply_send_status(r, 200, NULL) != 0){
		return rtx_error("Could not set HTTP response status");
	}

	if(rtx_httpd_reply_send_header(r, "Content-Type", "text/xml") != 0){
		return rtx_error("Could not set Content Type");
	}

	rtx_mutex_lock(messaged->mutex);
	ptr = rtx_longstring_content(messaged->logMess->w);
	if (ptr && *ptr) {
		if(rtx_httpd_reply_send_body(r,rtx_longstring_content(messaged->logMess->w),
					rtx_longstring_length(messaged->logMess->w))!=0) {
			rtx_mutex_unlock(messaged->mutex);
			return rtx_error("could not send response");
		}
	} else {
		if(rtx_httpd_reply_send_body(r,defaultStr,strlen(defaultStr))!=0) {
			rtx_mutex_unlock(messaged->mutex);
			return rtx_error("could not send response");
		}
	}
	rtx_mutex_unlock(messaged->mutex);

	return 0;
}

static int test(RtxHttpdReq * r){
	RtxLongString * html;
	html = rtx_longstring_init();
	rtx_longstring_concat(html,"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \\ \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> ");
	rtx_longstring_concat(html,"<html><head></head><body><h1>message daemon !</h1></body></html>");

	if(rtx_httpd_reply_send_status(r, 200, NULL) != 0){
		rtx_longstring_destroy(html);
		return rtx_error("Could not set HTTP response status");
	}

	if(rtx_httpd_reply_send_header(r, "Content-Type", "text/html") != 0){
		rtx_longstring_destroy(html);
		return rtx_error("Could not set Content Type");
	}

	if(rtx_httpd_reply_send_body(r,rtx_longstring_content(html),
				rtx_longstring_length(html))!=0) {
		rtx_longstring_destroy(html);
		return rtx_error("could not send response");
	}

	rtx_longstring_destroy(html);

	return 0;
}

static int getIndex(RtxHttpdReq * r){
	RtxLongString * html;
	html = rtx_longstring_init();
	rtx_longstring_concat(html,"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \\ \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> ");
	rtx_longstring_concat(html,"<html><head></head><body><h1>message daemon !</h1><ul>");
	rtx_longstring_concat(html,"<li><a href=\"messagelog\">Current list of messages</a></li>");
	rtx_longstring_concat(html,"<li><a href=\"archivefilelist\">Current list of message files</a></li>");
	rtx_longstring_concat(html,"<li><a href=\"downloadfile/messages\">Current message file</a></li>");
	rtx_longstring_concat(html,"<li>Download a specific file at \"/downloadfile/&lt;filename&gt;\"</li>");
	rtx_longstring_concat(html,"</ul></body></html>");

	if(rtx_httpd_reply_send_status(r, 200, NULL) != 0){
		rtx_longstring_destroy(html);
		return rtx_error("Could not set HTTP response status");
	}

	if(rtx_httpd_reply_send_header(r, "Content-Type", "text/html") != 0){
		rtx_longstring_destroy(html);
		return rtx_error("Could not set Content Type");
	}

	if(rtx_httpd_reply_send_body(r,rtx_longstring_content(html),
				rtx_longstring_length(html))!=0) {
		rtx_longstring_destroy(html);
		return rtx_error("could not send response");
	}

	rtx_longstring_destroy(html);

	return 0;
}



int messaged_web_handler(RtxHttpdReq * r){
	char filename[100]="";
	
	if(strcmp(r->url,"/messagelist")==0){
		get_messagelog(r);
	}else if (strcmp(r->url,"/messagelog") == 0){
		get_messagelog(r);
	}else if(strcmp(r->url,"/archivefilelist")==0){
		get_archivefilelist(r);
	}else if (sscanf(r->url,"/downloadfile/%s", filename)==1) {
		download_file(r);
	}else if (strcmp(r->url,"/test") == 0){
		test(r);
	}else{
		getIndex(r);
	}
		
	
	return 0;
}

int messaged_webServerStart(MESSAGED * messaged, unsigned int port){
	fprintf(stderr, "Initialising simple HTTPD server on port %d [debug=%d]\n",port,1);
	messaged->webserver = rtx_httpd_server_init(NULL,port,5,messaged_web_handler);
	if (!messaged->webserver) {
		return rtx_error("Failed to create HTTP server");
	}
	rtx_httpd_server_set_user_data(messaged->webserver,messaged);
	
	return 0;
}

int messaged_webServerStop(MESSAGED * messaged){
	if (messaged->webserver) {
		rtx_httpd_server_destroy(messaged->webserver);
		messaged->webserver = NULL;
	}
	return 0;
}




