/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 *
 * $Id: logMessage.h 2284 2007-12-24 00:20:48Z roy029 $
 *
 ***********************************************************************/

#ifndef __logMessage_h__
#define __logMessage_h__
#include <rtx/longstring.h>
#include <rtx/scircbuff.h>


/**
 * message's attributes
 */

#define MESSAGE_TYPE_LENGTH 5
#define MESSAGE_HOST_LENGTH 256
#define MESSAGE_DATE_LENGTH 50
#define MESSAGE_SOURCE_LENGTH 50
#define MESSAGE_CONTENT_LENGTH 256

typedef struct _message{
	char type[MESSAGE_TYPE_LENGTH];
	char host[MESSAGE_HOST_LENGTH];
	char date[MESSAGE_DATE_LENGTH];
	char source[MESSAGE_SOURCE_LENGTH];
	char content[MESSAGE_CONTENT_LENGTH];
	int empty;
}message;

/**
 * log_message's attributes
 */

typedef struct _log_message{
	RtxCircularStringBuffer* logBuffer;
	message* tabMessage;
	int tabMessage_size;
	RtxLongString* w;
	int empty;
}log_message;


/**
 * log_message's methods
 */

log_message* logMessage_init(RtxCircularStringBuffer *log);

int logMessage_isEmpty(log_message * logMess);

void logMessage_setTabMessage(log_message * logMess);

void logMessage_clear(log_message * logMess);

void logMessage_dump(log_message * logMess);

void logMessage_xmlConverter(log_message * logMess);

void logMessage_destroy(log_message* logMess);

/**
 * message's methods
 */

message* message_init();

void message_clear(message *message);

int message_isEmpty(message *message);

const char* message_getType(message *message);

const char* message_getDate(message *message);

const char* message_getSource(message *message);

const char* message_getContent(message *message);

void message_destroy(message* message);

#endif

