/***********************************************************************
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <rtx/scircbuff.h>
#include "logMessage.h"

static char rcsid[] RTX_UNUSED = "$Id: logMessage.c 2273 2007-12-23 04:50:57Z roy029 $";

/**
 * log_message's methods
 */

log_message* logMessage_init(RtxCircularStringBuffer *logBuffer){
	log_message *logMess;
	logMess = (log_message*)malloc(sizeof(log_message));
	logMess->logBuffer = logBuffer;
	logMess->tabMessage_size = logMess->logBuffer->size;
	logMess->tabMessage = (message*)malloc(logMess->tabMessage_size * sizeof(message));
	logMess->w = rtx_longstring_init();
	logMessage_clear(logMess);
	return logMess;
}

int logMessage_isEmpty(log_message * logMess){
	if(logMess->empty){
		return 1;
	}
	
	return 0;
}

void logMessage_clear(log_message * logMess)
{
	int i;
	for (i=0;i<logMess->tabMessage_size;i++) {
		message_clear(logMess->tabMessage + i);
	}
	logMess->empty = 1;
}

void logMessage_setTabMessage(log_message * logMess)
{
	char pattern[128];
	char date_sec[MESSAGE_DATE_LENGTH]="";
	int i = logMess->logBuffer->indexR;
	int j = 0;

	sprintf(pattern,"%%%d[^:]: %%%ds %%%d[^.]%%%d[^:]: %%%d[^:]:%%%d[^\n]",
			MESSAGE_TYPE_LENGTH-1,MESSAGE_HOST_LENGTH-1,MESSAGE_DATE_LENGTH-1,
			MESSAGE_DATE_LENGTH-1, MESSAGE_SOURCE_LENGTH-1,
			MESSAGE_CONTENT_LENGTH-1);
	logMessage_clear(logMess);
	do{
		
		date_sec[0] = date_sec[MESSAGE_DATE_LENGTH-1] = 0;
		if(logMess->logBuffer->buffer[i] != NULL){
#if 0
			printf("Scanning '%s' against '%s'\n",
					logMess->logBuffer->buffer[i], pattern);
#endif
			sscanf(logMess->logBuffer->buffer[i],pattern, 
				logMess->tabMessage[j].type, 
				logMess->tabMessage[j].host, 
				logMess->tabMessage[j].date,date_sec,
				logMess->tabMessage[j].source, 
				logMess->tabMessage[j].content);
	
			strcat(logMess->tabMessage[j].date,date_sec);
			logMess->tabMessage[j].empty = 0;
			logMess->empty = 0;
		}
		
		i=(i+1)%logMess->logBuffer->size;		
		j++;
	}while(i != logMess->logBuffer->indexW);
}

void logMessage_dump(log_message* logMess){
	int i;
	if(!logMessage_isEmpty(logMess)){
		printf("------------------------------------------log message dump %d\n", logMess->tabMessage_size);
		for(i = 0; i < logMess->tabMessage_size; i++){
			printf("%d \t%s %s %s %s\n",i, 
					logMess->tabMessage[i].type, 
					logMess->tabMessage[i].date,
					logMess->tabMessage[i].source, 
					logMess->tabMessage[i].content);
		}
	}
}

void logMessage_xmlConverter(log_message* logMess){
	int i;
	char tmp[256]="";
	rtx_longstring_clear(logMess->w);
	if(!logMessage_isEmpty(logMess)){
		rtx_longstring_concat(logMess->w, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
		rtx_longstring_concat(logMess->w, "<!DOCTYPE launcher SYSTEM \"./logMessage.dtd\">\n");
		rtx_longstring_concat(logMess->w, "<messagelist>");
		for(i = 0; i < logMess->tabMessage_size; i++){
			if(!logMess->tabMessage[i].empty){
				sprintf(tmp,"<message type=\"%s\" ", logMess->tabMessage[i].type);
				rtx_longstring_concat(logMess->w,tmp);
				sprintf(tmp,"host=\"%s\" ", logMess->tabMessage[i].host);
				rtx_longstring_concat(logMess->w,tmp);
				sprintf(tmp,"date=\"%s\" ", logMess->tabMessage[i].date);
				rtx_longstring_concat(logMess->w,tmp);
				sprintf(tmp,"source=\"%s\"><content>", logMess->tabMessage[i].source);
				rtx_longstring_concat(logMess->w,tmp);
				rtx_longstring_concat(logMess->w,logMess->tabMessage[i].content);
				rtx_longstring_concat(logMess->w,"</content></message>");
			}
		}
		rtx_longstring_concat(logMess->w, "</messagelist>");
	}
}

void logMessage_destroy(log_message* logMess){
	rtx_longstring_destroy(logMess->w);
	free(logMess->tabMessage);
	free(logMess);
}

/**
 * message's methods
 */

message* message_init()
{
	message *mess;
	mess = (message*)malloc(sizeof(message));
	message_clear(mess);
	return mess;
}

void message_clear(message *message)
{
	/* Set all the string empty */
	message->type[0] = 0;
	message->date[0] = 0;
	message->source[0] = 0;
	message->content[0] = 0;
	/* Be sure to put a zero at the end of all strings */
	message->type[MESSAGE_TYPE_LENGTH-1] = 0;
	message->date[MESSAGE_DATE_LENGTH-1] = 0;
	message->source[MESSAGE_SOURCE_LENGTH-1] = 0;
	message->content[MESSAGE_CONTENT_LENGTH-1] = 0;
	message->empty = 1;
}

int message_isEmpty(message *message)
{
	if(message->empty == 1){
		return 1;
	}
	return 0;
}

const char* message_getType(message *message)
{
	return message->type;
}

const char* message_getDate(message *message)
{
	return message->date;
}

const char* message_getSource(message *message)
{
	return message->source;
}

const char* message_getContent(message *message)
{
	return message->content;
}

void message_destroy(message* mess)
{
	if(mess != NULL){
		free(mess);
	}
}
