/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: rtcsvc.c 350 2003-05-12 02:45:56Z sik057 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * rtcsvc.c -- UNIX RPC server for RTC service
 *
 * This contains model code to run a single threaded server on Unix
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "rtc.h"

#ifdef __STRICT_ANSI__
extern int getopt(int, char *const *, const char *);
extern int getsubopt(char **, char *const *, char **);
extern int optind, opterr, optopt;
extern char *optarg;
#endif


static char *ping(int argc, char *argv[]) {
    /*
     * A ping server stub, registered under various names 
     * with the -r option
     */
    return argv[0];
}


int main(int argc, char *argv[])
{
    char c;
    unsigned program = 0;
    char transports[100];

    /* rtcServerDebug = rtc_bool_true; */
    *transports = '\0';

    /* initialise RTC server */
    if (rtcServerInit()) {
	rtcPerror(argv[0]);
	exit(1);
    }

    /* interpret args */
    while ((c = (char)getopt(argc, argv, "dt:h:u:g:r:p:")) != -1)
	switch (c) {
	case 'd':
	    rtcServerDebug = rtc_bool_true;
	    break;

	case 't':
	    if (*transports)
		strcat(transports, " ");
	    strcat(transports, optarg);
	    break;

	case 'h':
	    if (rtcServerAuth(rtc_auth_host, optarg, 0)) {
		rtcPerror(argv[0]);
		exit(1);
	    }
	    break;

	case 'u':
	    if (rtcServerAuth(rtc_auth_user, optarg, 0)) {
		rtcPerror(argv[0]);
		exit(1);
	    }
	    break;

	case 'g':
	    if (rtcServerAuth(rtc_auth_group, optarg, 0)) {
		rtcPerror(argv[0]);
		exit(1);
	    }
	    break;

	case 'r':
	    if (rtcServerRegister(optarg, ping)) {
		rtcPerror(argv[0]);
		exit(1);
	    }
	    break;

	case 'p':
	    program = abs(atoi(optarg));
	    break;

	case '?':
	default:
	    fprintf(stderr,
		"usage: %s [-d] [-p program] [-h hostname] "
		"[-u user] [-g group] [-r name] [-t transport] ...\n",
		argv[0]
	    );
	    exit(1);
	}

    /* print registered functions */
    if (rtcServerDebug)
	rtcServerShow();

    /* start server, which should not return */
    if (rtcServer(transports, program, argv[0])) {
	rtcPerror(argv[0]);
	exit(1);
    }

    rtcServerDone();
    return 0;
}
