/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: rtc.h 350 2003-05-12 02:45:56Z sik057 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * rtc.h -- user header file
 *
 * This file should be included in all applications (UNIX and vxWorks)
 * which will use the RTC server or clients
 */ 
#ifndef _rtc_h_
#define _rtc_h_

    /* function return code */
typedef enum {
    rtc_ok = 0,
    rtc_status_ok = 0,
    rtc_status_error,
    rtc_status_fatal
} RTC_STATUS;

    /* get error message after error */
extern char
    *rtcMessageGet(void);
#define rtcPerror(name) \
    fprintf(stderr, "%s: %s\n", name, rtcMessageGet());

    /* yet another boolean type */
typedef enum {
    rtc_bool_false,
    rtc_bool_true
} RTC_BOOL;


/*
 * USER SERVER SIDE FUNCTIONS
 *
 * RPC (and hence, RTC) servers are non-reentrant, so there can be only one
 * per process (on Unix-like systems) or per system (on shared-memory systems).
 * On multi-threaded systems, the server can be one thread, but the user is
 * reponsible for bringing the thread into existance and having it enter 
 * rtcServer(), as well as mutex locking of data accessed by the stub functions
 */

    /* the type of user server `stub functions' */
typedef char* (* RTC_EXEC)(int argc, char *argv[]);

    /* the tags for rtcServerAuth() */
typedef enum {
    rtc_auth_LAST = 0,
    rtc_auth_host,			/* hostname follows */
    rtc_auth_uid,			/* Unix UID number follows */
    rtc_auth_gid,			/* Unix GID number follows */
    rtc_auth_user,			/* Unix user name follows */
    rtc_auth_group			/* Unix group name follows */
} RTC_AUTH;


extern RTC_STATUS
    rtcServerInit(void),
    rtcServerAuth(RTC_AUTH tag, ...),
    rtcServerRegister(char *name, RTC_EXEC function),
    rtcServerDone(void),
    rtcServerShow(void),
    rtcServer(char *transports, unsigned program, char *name);

extern char
    *rtcServerBuffer(unsigned size);

extern RTC_BOOL
    rtcServerDebug;


/*
 * USER CLIENT SIDE FUNCTIONS
 *
 * Clients are (I hope) reentrant. The RTC client handle returned from
 * rtcClientCreate() should not be accessed directly by the user.
 */

    /* the RTC client handle */
typedef struct RTC_CLIENT *RTC;

    /* the tags for rtcClientConfigure() and rtcClientInterrogate() */
typedef enum {
    rtc_config_LAST = 0,
    rtc_config_name,			/* client name follows */
    rtc_config_server,			/* server hostname follows */
    rtc_config_program,			/* program number follows */
    rtc_config_transport,		/* transport string follows */
    rtc_config_timeout,			/* timeout in ms follows (integer) */
    rtc_config_retry,			/* retry period in ms follows */
    rtc_config_recreate,		/* recreate RPC bool follows */
    rtc_config_debug			/* debug bool follows */
} RTC_CONFIG;

extern RTC_STATUS
    rtcClientInit(void),
    rtcClientDone(void),
    rtcClientCreate(RTC *rtc, RTC_CONFIG tag, ...),
    rtcClientConfigure(RTC rtc, RTC_CONFIG tag, ...),
    rtcClientInterrogate(RTC rtc, RTC_CONFIG tag, ...),
    rtcClientCall(RTC rtc, int argc, char *argv[], char **resp),
    rtcClientResponseFree(char **resp),
    rtcClientDestroy(RTC rtc),
    rtcClientShow(RTC rtc);

extern RTC_BOOL
    rtcClientDebug;


#endif
