/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: return.c 350 2003-05-12 02:45:56Z sik057 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * return.c -- error return functions
 */
#include "internal.h"


RTC_STATUS rtcReturnError(char *emessage, char *file, unsigned int lineno) {
    /*
     * This is called from the rtcError() macro, which passes a user
     * message in emessage (which should be a static or const string pointer)
     * and the filename and line number where the error is generated. The 
     * message is stored for later use in user error messages. If the message
     * is NULL, rtc_emessage_set() uses a system message. This function
     * always returns rtc_status_error
     */
    rtcMessageSet(emessage);
    return rtc_status_error;
}

RTC_STATUS rtcReturnFatal(char *emessage, char *file, unsigned int lineno) {
    /*
     * As for rtcReturnError(), except an error message is logged, and 
     * rtc_status_fatal is returned. This causes the rtc_eret/fret() macros
     * to print the call stack as it is unwinds
     */
    rtcMessageSet(emessage);
    rtcLog(
	"RTC: FATAL ERROR: file %s, line %u: %s\n",
	file, lineno, emessage
    );
    return rtc_status_fatal;
}
