/*
 * This file is part of RTC, the Remote Tool Control library
 * CSIRO Division of Manufacturing Technology
 *
 * $Id: proto.x 350 2003-05-12 02:45:56Z sik057 $
 * Robin Kirkham, February 1997 (from PIRAT)
 *
 * rtc.x -- RPC protocol definition file
 *
 * Although the RTC library itself has been heavily revised, the
 * underlying RTC protocol, as defined by this file, is unchanged.
 * This file is used by rpcgen to produce the C header file proto.h
 * and the XDR routines, xdr.c
 */

   /* arguments--an array of strings and a serial */
typedef string rtcarg<>;

struct rtcargs {
    rtcarg arg<>;
    unsigned serial;
};

    /* return--a string and a status */
enum rtcretstat {
    RTCRETSTAT_OK,
    RTCRETSTAT_ERROR
};

struct rtcret {
    string str<>;
    rtcretstat stat;
};

    /* currently only one RPC function */
program RTCPROG {
    version RTCVERS {
	rtcret RTCCALL(rtcargs) = 1;
    } = 1;
} = 600000000;

/* end */
